/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.security.credential;

import java.security.PublicKey;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import se.swedenconnect.opensaml.xmlsec.encryption.KeyDerivationMethod;

public class KeyAgreementCredential
extends BasicCredential {
    private PublicKey senderGeneratedPublicKey;
    private Credential peerCredential;
    private String agreementMethodAlgorithm;
    private KeyDerivationMethod keyDerivationMethod;

    public KeyAgreementCredential(SecretKey secretKey, PublicKey senderGeneratedPublicKey, Credential peerCredential, String agreementMethodAlgorith, KeyDerivationMethod keyDerivationMethod) {
        super(secretKey);
        this.senderGeneratedPublicKey = (PublicKey)Constraint.isNotNull((Object)senderGeneratedPublicKey, (String)"senderGeneratedPublicKey must not be null");
        this.peerCredential = (Credential)Constraint.isNotNull((Object)peerCredential, (String)"peerCredential must not be null");
        this.agreementMethodAlgorithm = (String)Constraint.isNotNull((Object)agreementMethodAlgorith, (String)"agreementMethodAlgorith must not be null");
        this.keyDerivationMethod = (KeyDerivationMethod)Constraint.isNotNull((Object)keyDerivationMethod, (String)"keyDerivationMethod must not be null");
    }

    public Class<? extends Credential> getCredentialType() {
        return KeyAgreementCredential.class;
    }

    public PublicKey getSenderGeneratedPublicKey() {
        return this.senderGeneratedPublicKey;
    }

    public Credential getPeerCredential() {
        return this.peerCredential;
    }

    public String getAgreementMethodAlgorithm() {
        return this.agreementMethodAlgorithm;
    }

    public KeyDerivationMethod getKeyDerivationMethod() {
        try {
            return (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)this.keyDerivationMethod);
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new XMLRuntimeException("Failed to clone KeyDerivationMethod", (Exception)e);
        }
    }
}

