/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml;

import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.OpenSAMLInitializerConfig;
import se.swedenconnect.opensaml.xmlsec.ExtendedEncryptionConfiguration;
import se.swedenconnect.opensaml.xmlsec.config.ExtendedDefaultSecurityConfigurationBootstrap;

public class OpenSAMLSecurityExtensionConfig
implements OpenSAMLInitializerConfig {
    private Logger log = LoggerFactory.getLogger(OpenSAMLSecurityExtensionConfig.class);

    @Override
    public String getName() {
        return "opensaml-security-extension";
    }

    @Override
    public void preInitialize() throws Exception {
        if (Security.getProvider("BC") == null) {
            this.log.info("{}: Crypto provider '{}' is not installed, installing it ...", (Object)this.getName(), (Object)"BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            this.log.info("{}: Crypto provider '{}' was installed", (Object)this.getName(), (Object)"BC");
        }
    }

    @Override
    public void postInitialize() throws Exception {
        EncryptionConfiguration encryptionConfiguration = (EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class);
        if (ExtendedEncryptionConfiguration.class.isInstance(encryptionConfiguration)) {
            this.log.debug("{}: ExtendedEncryptionConfiguration already present in OpenSAML configuration", (Object)this.getName());
        } else {
            this.log.info("Adding key agreement support to system EncryptionConfiguration");
            ConfigurationService.register(EncryptionConfiguration.class, (Object)ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration(SecurityConfigurationSupport.getGlobalEncryptionConfiguration()));
            this.log.debug("{}: Extended encryption configuration successfully registered", (Object)this.getName());
        }
        BasicSignatureSigningConfiguration signingConfiguration = ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration(SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
        ConfigurationService.register(SignatureSigningConfiguration.class, (Object)signingConfiguration);
    }
}

