/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml;

import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.OpenSAMLInitializerConfig;
import se.swedenconnect.opensaml.xmlsec.config.SecurityConfiguration;

public class OpenSAMLSecurityDefaultsConfig
implements OpenSAMLInitializerConfig {
    private Logger log = LoggerFactory.getLogger(OpenSAMLSecurityDefaultsConfig.class);
    private SecurityConfiguration securityConfiguration;

    public OpenSAMLSecurityDefaultsConfig(SecurityConfiguration securityConfiguration) {
        this.securityConfiguration = (SecurityConfiguration)Constraint.isNotNull((Object)securityConfiguration, (String)"securityConfiguration must not be null");
    }

    @Override
    public String getName() {
        return "opensaml-security-config";
    }

    @Override
    public void preInitialize() throws Exception {
    }

    @Override
    public void postInitialize() throws Exception {
        this.log.info("Updating OpenSAML security configuration defaults using profile '{}' ...", (Object)this.securityConfiguration.getProfileName());
        this.securityConfiguration.initOpenSAML();
        this.log.info("OpenSAML security configuration defaults updated by profile {}", (Object)this.securityConfiguration.getProfileName());
    }
}

