/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml;

import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.OpenSAMLInitializerConfig;

public class OpenSAMLInitializer {
    private Logger log = LoggerFactory.getLogger(OpenSAMLInitializer.class);
    private boolean initialized;
    private ParserPool parserPool;
    private static final Map<String, Boolean> builderFeatures = new HashMap<String, Boolean>();
    private static OpenSAMLInitializer INSTANCE;

    public static OpenSAMLInitializer getInstance() {
        return INSTANCE;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void initialize(OpenSAMLInitializerConfig ... customConfigs) throws Exception {
        if (this.initialized) {
            this.log.info("OpenSAML 3.X library has already been initialized");
            return;
        }
        if (customConfigs != null) {
            for (OpenSAMLInitializerConfig config : customConfigs) {
                this.log.debug("Invoking preInitialize for configurer '{}' ...", (Object)config.getName());
                config.preInitialize();
                this.log.debug("preInitialize for configurer '{}' was successfully executed", (Object)config.getName());
            }
        }
        this.log.debug("Initializing OpenSAML 3.X library...");
        InitializationService.initialize();
        OpenSAMLInitializerConfig[] openSAMLInitializerConfigArray = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            if (registry == null) {
                this.log.debug("XMLObjectProviderRegistry did not exist in ConfigurationService, will be created");
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (this.parserPool != null) {
                this.log.debug("Installing configured parser pool to XMLObjectProviderRegistry...");
                registry.setParserPool(this.parserPool);
            } else if (registry.getParserPool() == null) {
                this.log.debug("Installing default parser pool to XMLObjectProviderRegistry...");
                registry.setParserPool(OpenSAMLInitializer.createDefaultParserPool());
            }
            this.log.info("OpenSAML library 3.X successfully initialized");
            if (customConfigs != null) {
                for (OpenSAMLInitializerConfig config : customConfigs) {
                    this.log.debug("Invoking postInitialize for configurer '{}' ...", (Object)config.getName());
                    config.postInitialize();
                    this.log.debug("postInitialize for configurer '{}' was successfully executed", (Object)config.getName());
                }
            }
            this.initialized = true;
            return;
        }
    }

    public void setParserPool(ParserPool parserPool) {
        this.parserPool = parserPool;
        if (this.isInitialized()) {
            this.log.info("OpenSAML 3.X library has already been initialized - setting supplied parser pool to registry");
            XMLObjectProviderRegistrySupport.setParserPool((ParserPool)parserPool);
        }
    }

    public static ParserPool createDefaultParserPool() throws ComponentInitializationException {
        BasicParserPool basicParserPool = new BasicParserPool();
        basicParserPool.setMaxPoolSize(100);
        basicParserPool.setCoalescing(true);
        basicParserPool.setIgnoreComments(true);
        basicParserPool.setIgnoreElementContentWhitespace(true);
        basicParserPool.setNamespaceAware(true);
        basicParserPool.setBuilderFeatures(builderFeatures);
        basicParserPool.initialize();
        return basicParserPool;
    }

    protected OpenSAMLInitializer() {
    }

    static {
        builderFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        builderFeatures.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        builderFeatures.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        INSTANCE = new OpenSAMLInitializer();
    }
}

