/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Writer;
import se.natusoft.json.JSONArray;
import se.natusoft.json.JSONBoolean;
import se.natusoft.json.JSONEOFException;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONNull;
import se.natusoft.json.JSONNumber;
import se.natusoft.json.JSONObject;
import se.natusoft.json.JSONString;

public abstract class JSONValue {
    private JSONErrorHandler errorHandler = null;
    private String indent = "";

    protected JSONValue() {
    }

    protected JSONValue(JSONErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected abstract void readJSON(char var1, JSONReader var2) throws IOException;

    protected abstract void writeJSON(JSONWriter var1, boolean var2) throws IOException;

    protected JSONErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    static JSONValue resolveAndParseJSONValue(char c, JSONReader reader, JSONErrorHandler errorHandler) throws IOException {
        c = reader.skipWhitespace(c);
        JSONValue value = null;
        if (JSONObject.isObjectStart(c)) {
            value = JSONValue.createObject(errorHandler);
            value.readJSON(c, reader);
        } else if (JSONString.isStringStart(c)) {
            value = JSONValue.createString(errorHandler);
            value.readJSON(c, reader);
        } else if (JSONNumber.isNumberStart(c)) {
            value = JSONValue.createNumber(errorHandler);
            value.readJSON(c, reader);
        } else if (JSONBoolean.isBooleanStart(c)) {
            value = JSONValue.createBoolean(errorHandler);
            value.readJSON(c, reader);
        } else if (JSONNull.isNullStart(c)) {
            value = JSONValue.createNull(errorHandler);
            value.readJSON(c, reader);
        } else if (JSONArray.isArrayStart(c)) {
            value = JSONValue.createArray(errorHandler);
            value.readJSON(c, reader);
        } else {
            errorHandler.fail("Non expected character '" + c + "' found in input stream. This does not match the start of any acceptable value!", null);
        }
        return value;
    }

    void setIndent(String indent) {
        this.indent = indent;
    }

    String getIndent() {
        return this.indent;
    }

    protected void warn(String message) {
        if (this.errorHandler == null) {
            throw new IllegalStateException("Bad state! You have probably tried to call readJSON() on an instance created for writing (== no error support!)");
        }
        this.errorHandler.warning(message);
    }

    protected void fail(String message, Throwable cause) {
        if (this.errorHandler == null) {
            throw new IllegalStateException("Bad state! You have probably tried to call readJSON() on an instance created for writing (== no error support!)");
        }
        this.errorHandler.fail(message, cause);
    }

    protected void fail(String message) {
        this.fail(message, null);
        throw new RuntimeException("Bad developer! The implementation of JSONErrorHandler should always throw an exception on fail(...)!");
    }

    public void readJSON(InputStream is) throws IOException {
        JSONReader reader = new JSONReader(new PushbackReader(new InputStreamReader(is, "UTF-8")), this.errorHandler);
        this.readJSON(reader.getChar(), reader);
    }

    public void writeJSON(OutputStream os) throws IOException {
        this.writeJSON(os, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJSON(OutputStream os, boolean compact) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        try {
            this.writeJSON(new JSONWriter(osw), compact);
        }
        finally {
            osw.flush();
            osw.close();
        }
    }

    private static <T> T createFilter(T jsonObj) {
        return jsonObj;
    }

    static JSONString createString(JSONErrorHandler errorHandler) {
        return JSONValue.createFilter(new JSONString(errorHandler));
    }

    static JSONNumber createNumber(JSONErrorHandler errorHandler) {
        return JSONValue.createFilter(new JSONNumber(errorHandler));
    }

    static JSONNull createNull(JSONErrorHandler errorHandler) {
        return JSONValue.createFilter(new JSONNull(errorHandler));
    }

    static JSONBoolean createBoolean(JSONErrorHandler errorHandler) {
        return JSONValue.createFilter(new JSONBoolean(errorHandler));
    }

    static JSONArray createArray(JSONErrorHandler errorHandler) {
        return JSONValue.createFilter(new JSONArray(errorHandler));
    }

    static JSONObject createObject(JSONErrorHandler errorHandler) {
        return JSONValue.createFilter(new JSONObject(errorHandler));
    }

    protected static class JSONWriter {
        private Writer writer = null;

        protected JSONWriter(Writer writer) {
            this.writer = writer;
        }

        protected void write(String json) throws IOException {
            this.writer.write(json);
        }

        protected void writeln(String json) throws IOException {
            this.writer.write(json);
            this.writer.write("\n");
        }
    }

    static class JSONReader {
        private PushbackReader reader = null;
        private JSONErrorHandler errorHandler = null;

        protected JSONReader(PushbackReader reader, JSONErrorHandler errorHandler) {
            this.reader = reader;
            this.errorHandler = errorHandler;
        }

        protected char getChar() throws IOException {
            return this.getChar(false);
        }

        protected char getChar(boolean handleEscapes) throws IOException {
            char[] cbuff = new char[1];
            int noRead = this.reader.read(cbuff, 0, 1);
            if (noRead <= 0) {
                this.errorHandler.fail("Unexpected end-of-file!", null);
                throw new JSONEOFException();
            }
            char c = cbuff[0];
            if (handleEscapes) {
                c = this.handleEscape(c);
            }
            return c;
        }

        protected void ungetChar(char c) throws IOException {
            char[] cbuff = new char[]{c};
            this.reader.unread(cbuff);
        }

        protected char skipWhitespace(char c) throws IOException {
            while (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                c = this.getChar();
            }
            return c;
        }

        protected char skipWhitespace() throws IOException {
            return this.skipWhitespace(this.getChar());
        }

        private char handleEscape(char c) throws IOException {
            if (c == '\\') {
                c = this.getChar();
                if (c == 'b') {
                    c = (char)8;
                } else if (c == 'f') {
                    c = (char)12;
                } else if (c == 'n') {
                    c = (char)10;
                } else if (c == 'r') {
                    c = (char)13;
                } else if (c == 't') {
                    c = (char)9;
                } else if (c == 'u') {
                    byte[] hexDigits = new byte[4];
                    char[] hexChars = new char[]{this.getChar(), this.getChar(), this.getChar(), this.getChar()};
                    for (int i = 0; i < 4; ++i) {
                        char h = hexChars[i];
                        if (h == '0') {
                            hexDigits[i] = 0;
                            continue;
                        }
                        if (h == '1') {
                            hexDigits[i] = 1;
                            continue;
                        }
                        if (h == '2') {
                            hexDigits[i] = 2;
                            continue;
                        }
                        if (h == '3') {
                            hexDigits[i] = 3;
                            continue;
                        }
                        if (h == '4') {
                            hexDigits[i] = 4;
                            continue;
                        }
                        if (h == '5') {
                            hexDigits[i] = 5;
                            continue;
                        }
                        if (h == '6') {
                            hexDigits[i] = 6;
                            continue;
                        }
                        if (h == '7') {
                            hexDigits[i] = 7;
                            continue;
                        }
                        if (h == '8') {
                            hexDigits[i] = 8;
                            continue;
                        }
                        if (h == '9') {
                            hexDigits[i] = 9;
                            continue;
                        }
                        if (h == 'a' || h == 'A') {
                            hexDigits[i] = 10;
                            continue;
                        }
                        if (h == 'b' || h == 'B') {
                            hexDigits[i] = 11;
                            continue;
                        }
                        if (h == 'c' || h == 'C') {
                            hexDigits[i] = 12;
                            continue;
                        }
                        if (h == 'd' || h == 'D') {
                            hexDigits[i] = 13;
                            continue;
                        }
                        if (h == 'e' || h == 'E') {
                            hexDigits[i] = 14;
                            continue;
                        }
                        if (h != 'f' && h != 'F') continue;
                        hexDigits[i] = 15;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(hexDigits[0]);
                    sb.append(hexDigits[1]);
                    sb.append(hexDigits[2]);
                    sb.append(hexDigits[3]);
                    int ucode = Integer.parseInt(sb.toString().toUpperCase(), 16);
                    c = (char)ucode;
                }
            }
            return c;
        }

        protected char readUntil(String until, char c, StringBuilder sb, boolean handleEscapes) throws IOException {
            while (until.indexOf(c) < 0) {
                sb.append(c);
                c = this.getChar(handleEscapes);
            }
            return c;
        }

        protected char readUntil(String until, StringBuilder sb, boolean string) throws IOException {
            return this.readUntil(until, this.getChar(), sb, string);
        }

        protected char readUntil(String until, StringBuilder sb) throws IOException {
            return this.readUntil(until, sb, false);
        }

        protected boolean checkValidChar(char c, String validChars) {
            return validChars.indexOf(c) >= 0;
        }

        protected void assertChar(char a, char e, String message) {
            if (a != e) {
                this.errorHandler.fail("Assert: " + message, null);
            }
        }

        protected void assertChar(char a, String expected, String message) {
            if (expected.indexOf(a) < 0) {
                this.errorHandler.fail("Assert: " + message, null);
            }
        }
    }
}

