/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json;

import java.io.IOException;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONValue;

public class JSONNull
extends JSONValue {
    public JSONNull() {
    }

    public JSONNull(JSONErrorHandler errorHandler) {
        super(errorHandler);
    }

    static boolean isNullStart(char c) {
        return c == 'n';
    }

    public String toString() {
        return "null";
    }

    @Override
    protected void readJSON(char c, JSONValue.JSONReader reader) throws IOException {
        reader.assertChar(c, "n", "Expected an 'n' (first char in \"null\"!");
        c = reader.getChar();
        reader.assertChar(c, "u", "Expected an 'u' (second char in \"null\"!");
        c = reader.getChar();
        reader.assertChar(c, "l", "Expected an 'l' (third char in \"null\"!");
        c = reader.getChar();
        reader.assertChar(c, "l", "Expected an 'l' (fourth char in \"null\"!");
    }

    @Override
    protected void writeJSON(JSONValue.JSONWriter writer, boolean compact) throws IOException {
        writer.write("null");
    }
}

