/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json;

import java.io.IOException;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONValue;

public class JSONBoolean
extends JSONValue {
    private boolean value;

    public JSONBoolean(boolean value) {
        this.value = value;
    }

    public JSONBoolean(JSONErrorHandler errorHandler) {
        super(errorHandler);
    }

    static boolean isBooleanStart(char c) {
        return c == 't' || c == 'f';
    }

    public void setBooleanValue(boolean value) {
        this.value = value;
    }

    public boolean getAsBoolean() {
        return this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    protected void readJSON(char c, JSONValue.JSONReader reader) throws IOException {
        if (c == 't') {
            c = reader.getChar();
            reader.assertChar(c, 'r', "Expected a 'r' character (Second character of 'true')!");
            c = reader.getChar();
            reader.assertChar(c, 'u', "Expected a 'u' character (Third character of 'true')!");
            c = reader.getChar();
            reader.assertChar(c, 'e', "Expected a 'e' character (Fourth character of 'true')!");
            this.value = true;
        } else if (c == 'f') {
            c = reader.getChar();
            reader.assertChar(c, 'a', "Expected a 'a' character (Second character of 'false')!");
            c = reader.getChar();
            reader.assertChar(c, 'l', "Expected a 'l' character (Third character of 'false')!");
            c = reader.getChar();
            reader.assertChar(c, 's', "Expected a 's' character (Fourth character of 'false')!");
            c = reader.getChar();
            reader.assertChar(c, 'e', "Expected a 'e' character (Firth character of 'false')!");
            this.value = false;
        } else {
            this.fail("A boolean value must start with either a 't' or a 'f'!");
        }
    }

    @Override
    protected void writeJSON(JSONValue.JSONWriter writer, boolean compact) throws IOException {
        writer.write("" + this.value);
    }
}

