/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONValue;

public class JSONArray
extends JSONValue {
    private List<JSONValue> values = new ArrayList<JSONValue>();

    public JSONArray() {
    }

    public JSONArray(JSONErrorHandler errorHandler) {
        super(errorHandler);
    }

    static boolean isArrayStart(char c) {
        return c == '[';
    }

    static boolean isArrayEnd(char c) {
        return c == ']';
    }

    public void addValue(JSONValue value) {
        this.values.add(value);
    }

    public List<JSONValue> getAsList() {
        return this.values;
    }

    public <T extends JSONValue> List<T> getAsList(Class<T> type) {
        LinkedList<JSONValue> list = new LinkedList<JSONValue>();
        for (JSONValue value : this.values) {
            list.add(value);
        }
        return list;
    }

    @Override
    protected void readJSON(char c, JSONValue.JSONReader reader) throws IOException {
        c = reader.skipWhitespace(c);
        reader.assertChar(c, '[', "A JSON array must start with a '[' char!");
        c = reader.getChar();
        boolean done = false;
        while (!done) {
            c = reader.skipWhitespace(c);
            JSONValue value = null;
            if (!JSONArray.isArrayEnd(c)) {
                value = JSONValue.resolveAndParseJSONValue(c, reader, this.getErrorHandler());
            }
            if (value != null) {
                this.values.add(value);
                c = reader.getChar();
                c = reader.skipWhitespace(c);
                if (JSONArray.isArrayEnd(c)) {
                    done = true;
                    continue;
                }
                reader.assertChar(c, ",", "An array value must be followed by a comma ',' or ended with a ']'! Found unexpected char: '" + c + "'!");
                c = reader.getChar();
                continue;
            }
            done = true;
        }
    }

    @Override
    protected void writeJSON(JSONValue.JSONWriter writer, boolean compact) throws IOException {
        if (!compact) {
            writer.writeln("");
            writer.write(this.getIndent());
        }
        writer.write("[");
        if (!compact) {
            writer.writeln("");
        }
        int current = 0;
        int max = this.values.size();
        for (JSONValue value : this.values) {
            value.setIndent(this.getIndent() + "    ");
            if (!compact) {
                writer.write(value.getIndent());
            }
            value.writeJSON(writer, compact);
            if (++current < max) {
                writer.write(", ");
                if (compact) continue;
                writer.writeln("");
                continue;
            }
            if (compact) continue;
            writer.writeln("");
        }
        if (!compact) {
            writer.write(this.getIndent());
        }
        writer.write("]");
    }
}

