/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.validation;

import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.AbstractSubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.common.validation.AbstractObjectValidator;

public class SwedishEidSubjectConfirmationValidator
extends AbstractSubjectConfirmationValidator {
    private final Logger log = LoggerFactory.getLogger(SwedishEidSubjectConfirmationValidator.class);

    public String getServicedMethod() {
        return "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    }

    protected ValidationResult doValidate(SubjectConfirmation confirmation, Assertion assertion, ValidationContext context) throws AssertionValidationException {
        if (confirmation.getSubjectConfirmationData() == null) {
            String msg = String.format("SubjectConfirmationData is missing from Subject/@SubjectConfirmation for method '%s' for Assertion '%s'", this.getServicedMethod(), assertion.getID());
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        this.validateInResponseTo(confirmation, assertion, context);
        if (confirmation.getSubjectConfirmationData().getNotOnOrAfter() == null) {
            String msg = String.format("NotOnOrAfter attribute is missing from Subject/@SubjectConfirmationData for method '%s' for Assertion '%s'", this.getServicedMethod(), assertion.getID());
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        if (confirmation.getSubjectConfirmationData().getRecipient() == null) {
            String msg = String.format("Recipient attribute is missing from Subject/@SubjectConfirmationData for method '%s' for Assertion '%s'", this.getServicedMethod(), assertion.getID());
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateInResponseTo(SubjectConfirmation confirmation, Assertion assertion, ValidationContext context) {
        String msg;
        AuthnRequest authnRequest;
        if (confirmation.getSubjectConfirmationData().getInResponseTo() == null) {
            String msg2 = String.format("InResponseTo attribute is missing from Subject/@SubjectConfirmationData for method '%s' for Assertion '%s'", this.getServicedMethod(), assertion.getID());
            context.setValidationFailureMessage(msg2);
            return ValidationResult.INVALID;
        }
        String inResponseTo = confirmation.getSubjectConfirmationData().getInResponseTo();
        String expectedInResponseTo = (String)context.getStaticParameters().get("saml2.AuthnRequestID");
        if (expectedInResponseTo == null && (authnRequest = (AuthnRequest)context.getStaticParameters().get("saml2.AuthnRequest")) != null) {
            expectedInResponseTo = authnRequest.getID();
        }
        if (expectedInResponseTo != null) {
            if (!inResponseTo.equals(expectedInResponseTo)) {
                msg = String.format("Mismatching InResponseTo attribute is missing from Subject/@SubjectConfirmationData for method '%s' for Assertion '%s'. Expected: '%s', was: '%s'", this.getServicedMethod(), assertion.getID(), expectedInResponseTo, inResponseTo);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        } else {
            msg = String.format("Could not validate InResponseTo attribute is missing from Subject/@SubjectConfirmationData for method '%s' for Assertion '%s' (no AuthnRequest ID available)", this.getServicedMethod(), assertion.getID());
            context.setValidationFailureMessage(msg);
            return ValidationResult.INDETERMINATE;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateAddress(SubjectConfirmation confirmation, Assertion assertion, ValidationContext context) throws AssertionValidationException {
        String address = StringSupport.trimOrNull((String)confirmation.getSubjectConfirmationData().getAddress());
        if (address == null) {
            String msg = String.format("SubjectConfirmationData of Assertion '%s' is missing Address attribute", assertion.getID());
            if (AbstractObjectValidator.isStrictValidation((ValidationContext)context)) {
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
            this.log.warn(msg);
        }
        if (!AbstractObjectValidator.isStrictValidation((ValidationContext)context) && context.getStaticParameters().get("saml2.SubjectConfirmation.ValidAddresses") == null) {
            this.log.info("Address check skipped for SubjectConfirmationData - no indata supplied");
            return ValidationResult.VALID;
        }
        ValidationResult result = super.validateAddress(confirmation, assertion, context);
        if (result != ValidationResult.VALID && !AbstractObjectValidator.isStrictValidation((ValidationContext)context)) {
            String msg = context.getValidationFailureMessage();
            this.log.warn(msg);
            context.setValidationFailureMessage(null);
            return ValidationResult.VALID;
        }
        return result;
    }
}

