/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.validation;

import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.response.ResponseValidator;

public class SwedishEidResponseValidator
extends ResponseValidator {
    private final Logger log = LoggerFactory.getLogger(SwedishEidResponseValidator.class);

    public SwedishEidResponseValidator(SignatureTrustEngine trustEngine, SignaturePrevalidator signaturePrevalidator) throws IllegalArgumentException {
        super(trustEngine, signaturePrevalidator);
        if (trustEngine == null) {
            throw new IllegalArgumentException("trustEngine must not be null");
        }
        if (signaturePrevalidator == null) {
            throw new IllegalArgumentException("signaturePrevalidator must not be null");
        }
    }

    protected ValidationResult validateSignature(Response token, ValidationContext context) {
        Boolean signatureRequired = (Boolean)context.getStaticParameters().get("saml2.SignatureRequired");
        if (signatureRequired != null && !signatureRequired.booleanValue()) {
            this.log.warn("The flag CoreValidatorParameters.SIGNATURE_REQUIRED is false - signature validation MUST be performed according to the Swedish eID Framework - Setting flag to true");
        }
        if (!token.isSigned()) {
            context.setValidationFailureMessage(String.format("%s was required to be signed, but was not", this.getObjectName()));
            return ValidationResult.INVALID;
        }
        return this.performSignatureValidation((SignableXMLObject)token, context);
    }

    public ValidationResult validateAssertions(Response response, ValidationContext context) {
        ValidationResult result = super.validateAssertions(response, context);
        if (!result.equals((Object)ValidationResult.VALID)) {
            return result;
        }
        if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            String msg;
            if (response.getEncryptedAssertions().isEmpty()) {
                context.setValidationFailureMessage("Response does not contain EncryptedAssertion");
                return ValidationResult.INVALID;
            }
            if (response.getEncryptedAssertions().size() > 1) {
                msg = "Response contains more than one EncryptedAssertion";
                if (SwedishEidResponseValidator.isStrictValidation((ValidationContext)context)) {
                    context.setValidationFailureMessage(msg);
                    return ValidationResult.INVALID;
                }
                this.log.warn(msg);
            }
            if (!response.getAssertions().isEmpty()) {
                msg = "Response contains non encrypted Assertion(s)";
                if (SwedishEidResponseValidator.isStrictValidation((ValidationContext)context)) {
                    context.setValidationFailureMessage(msg);
                    return ValidationResult.INVALID;
                }
                this.log.warn(msg);
            }
        }
        return ValidationResult.VALID;
    }
}

