/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.assertion.AuthnStatementValidator;

public class SwedishEidAuthnStatementValidator
extends AuthnStatementValidator {
    public static final String AUTHN_REQUEST_REQUESTED_AUTHNCONTEXTURIS = "saml2.AuthnRequestRequestedAuthnContextURIs";
    private final Logger log = LoggerFactory.getLogger(SwedishEidAuthnStatementValidator.class);

    protected ValidationResult validateAuthnContext(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        ValidationResult res = super.validateAuthnContext(statement, assertion, context);
        if (res != ValidationResult.VALID) {
            return res;
        }
        if (statement.getAuthnContext().getAuthnContextClassRef() == null || statement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef() == null) {
            context.setValidationFailureMessage("Missing AuthnContextClassRef URI from Assertion/@AuthnStatement/@AuthnContext");
            return ValidationResult.INVALID;
        }
        Collection<String> requestedUris = SwedishEidAuthnStatementValidator.getRequestedAuthnContextUris(context);
        if (requestedUris.isEmpty()) {
            this.log.debug("No RequestedAuthnContext URI was requested - will not check issued AuthnContextClassRef");
            return ValidationResult.VALID;
        }
        return this.validateAuthnContextClassRef(statement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef(), requestedUris, statement, assertion, context);
    }

    protected ValidationResult validateAuthnContextClassRef(String authnContextClassRef, Collection<String> requestedContextClassRefs, AuthnStatement statement, Assertion assertion, ValidationContext context) {
        if (!requestedContextClassRefs.contains(authnContextClassRef)) {
            String msg = String.format("Assertion contained AuthnContextClassRef '%s', but that one was not requested (%s)", authnContextClassRef, requestedContextClassRefs);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected static Collection<String> getRequestedAuthnContextUris(ValidationContext context) {
        AuthnRequest authnRequest;
        List<String> uris = (List<String>)context.getStaticParameters().get(AUTHN_REQUEST_REQUESTED_AUTHNCONTEXTURIS);
        if ((uris == null || uris.isEmpty()) && (authnRequest = (AuthnRequest)context.getStaticParameters().get("saml2.AuthnRequest")) != null && authnRequest.getRequestedAuthnContext() != null && authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs() != null && !authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().isEmpty()) {
            uris = new ArrayList<String>();
            uris.addAll(authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().stream().map(a -> a.getAuthnContextClassRef()).collect(Collectors.toList()));
        }
        return uris != null ? uris : Collections.emptyList();
    }
}

