/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.assertion.AbstractAttributeStatementValidator;
import se.litsec.swedisheid.opensaml.saml2.attribute.AttributeSet;
import se.litsec.swedisheid.opensaml.saml2.attribute.AttributesValidationException;

public class SwedishEidAttributeStatementValidator
extends AbstractAttributeStatementValidator {
    public static final String REQUIRED_ATTRIBUTE_SET = "saml2.RequiredAttributeSet";
    public static final String REQUIRED_ATTRIBUTES = "saml2.RequiredAttributes";
    private final Logger log = LoggerFactory.getLogger(SwedishEidAttributeStatementValidator.class);

    protected ValidationResult validateRequiredAttributes(List<Attribute> attributes, AttributeStatement statement, Assertion assertion, ValidationContext context) {
        Collection<String> requiredAttributes;
        AttributeSet attributeSet = (AttributeSet)context.getStaticParameters().get(REQUIRED_ATTRIBUTE_SET);
        if (attributeSet != null) {
            try {
                attributeSet.validateAttributes(assertion, null);
            }
            catch (AttributesValidationException e) {
                this.log.info("Required attributes check failed: {}", (Object)e.getMessage());
                context.setValidationFailureMessage(e.getMessage());
                return ValidationResult.INVALID;
            }
        }
        if ((requiredAttributes = this.getRequiredAttributes(context)) != null) {
            for (String attr : requiredAttributes) {
                if (attributes.stream().filter(a -> attr.equals(a.getName())).findAny().isPresent()) continue;
                String msg = String.format("Required attribute '%s' was not part of the attribute statement", attr);
                this.log.info("Required attributes check failed: {}", (Object)msg);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        }
        if (attributeSet == null && requiredAttributes.isEmpty()) {
            this.log.debug("No required attributes were supplied - can not check if required attributes were delivered");
        }
        return ValidationResult.VALID;
    }

    protected Collection<String> getRequiredAttributes(ValidationContext context) {
        List<String> attributes = (List<String>)context.getStaticParameters().get(REQUIRED_ATTRIBUTES);
        return attributes != null ? attributes : Collections.emptyList();
    }
}

