/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.assertion.AssertionValidator;
import se.litsec.swedisheid.opensaml.saml2.validation.SwedishEidAttributeStatementValidator;
import se.litsec.swedisheid.opensaml.saml2.validation.SwedishEidAuthnStatementValidator;
import se.litsec.swedisheid.opensaml.saml2.validation.SwedishEidSubjectConfirmationValidator;

public class SwedishEidAssertionValidator
extends AssertionValidator {
    private final Logger log = LoggerFactory.getLogger(SwedishEidAssertionValidator.class);

    public SwedishEidAssertionValidator(SignatureTrustEngine trustEngine, SignaturePrevalidator signaturePrevalidator) {
        this(trustEngine, signaturePrevalidator, Arrays.asList(new SubjectConfirmationValidator[]{new SwedishEidSubjectConfirmationValidator()}), Arrays.asList(new AudienceRestrictionConditionValidator()), Arrays.asList(new StatementValidator[]{new SwedishEidAuthnStatementValidator(), new SwedishEidAttributeStatementValidator()}));
    }

    public SwedishEidAssertionValidator(SignatureTrustEngine trustEngine, SignaturePrevalidator signaturePrevalidator, Collection<SubjectConfirmationValidator> confirmationValidators, Collection<ConditionValidator> conditionValidators, Collection<StatementValidator> statementValidators) {
        super(trustEngine, signaturePrevalidator, confirmationValidators, conditionValidators, statementValidators);
    }

    protected ValidationResult validateSubject(Assertion assertion, ValidationContext context) {
        if (assertion.getSubject() == null) {
            context.setValidationFailureMessage("Missing Subject element in Assertion");
            return ValidationResult.INVALID;
        }
        if (assertion.getSubject().getNameID() == null) {
            context.setValidationFailureMessage("Missing NameID in Subject element of Assertion");
            return ValidationResult.INVALID;
        }
        if (assertion.getSubject().getNameID().getValue() == null) {
            context.setValidationFailureMessage("Missing NameID value in Subject element of Assertion");
            return ValidationResult.INVALID;
        }
        if (assertion.getSubject().getNameID().getFormat() == null) {
            String msg = "NameID element of Assertion/@Subject is missing Format attribute";
            if (SwedishEidAssertionValidator.isStrictValidation((ValidationContext)context)) {
                context.setValidationFailureMessage("NameID element of Assertion/@Subject is missing Format attribute");
                return ValidationResult.INVALID;
            }
            this.log.warn("NameID element of Assertion/@Subject is missing Format attribute");
        } else {
            String format = assertion.getSubject().getNameID().getFormat();
            if (!format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent") && !format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
                String msg = String.format("NameID format in Subject of Assertion is not valid (%s) - '%s' or '%s' is required", format, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
                if (SwedishEidAssertionValidator.isStrictValidation((ValidationContext)context)) {
                    context.setValidationFailureMessage(msg);
                    return ValidationResult.INVALID;
                }
                this.log.warn(msg);
            }
        }
        List confirmations = assertion.getSubject().getSubjectConfirmations();
        if (confirmations == null || confirmations.isEmpty()) {
            context.setValidationFailureMessage("Assertion/@Subject element contains no SubjectConfirmation elements - invalid");
            return ValidationResult.INVALID;
        }
        boolean bearerFound = false;
        for (SubjectConfirmation sc : confirmations) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(sc.getMethod())) continue;
            bearerFound = true;
            break;
        }
        if (!bearerFound) {
            String msg = String.format("No SubjectConfirmation with method '%s' is available under Assertion's Subject element", "urn:oasis:names:tc:SAML:2.0:cm:bearer");
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        return super.validateSubject(assertion, context);
    }

    protected ValidationResult validateConditions(Assertion assertion, ValidationContext context) {
        if (assertion.getConditions() == null) {
            context.setValidationFailureMessage("Missing Conditions element in Assertion");
            return ValidationResult.INVALID;
        }
        if (assertion.getConditions().getNotBefore() == null) {
            context.setValidationFailureMessage("Missing NotBefore attribute of Conditions element in Assertion");
            return ValidationResult.INVALID;
        }
        if (assertion.getConditions().getNotOnOrAfter() == null) {
            context.setValidationFailureMessage("Missing NotOnOrAfter attribute of Conditions element in Assertion");
            return ValidationResult.INVALID;
        }
        if (assertion.getConditions().getAudienceRestrictions().isEmpty()) {
            context.setValidationFailureMessage("Missing AudienceRestriction element of Conditions element in Assertion");
            return ValidationResult.INVALID;
        }
        return super.validateConditions(assertion, context);
    }

    protected ValidationResult validateStatements(Assertion assertion, ValidationContext context) {
        if (assertion.getAuthnStatements() == null || assertion.getAuthnStatements().isEmpty()) {
            context.setValidationFailureMessage("No AuthnStatement in Assertion");
            return ValidationResult.INVALID;
        }
        if (assertion.getAttributeStatements() == null || assertion.getAttributeStatements().isEmpty()) {
            context.setValidationFailureMessage("No AttributeStatement in Assertion");
            return ValidationResult.INVALID;
        }
        return super.validateStatements(assertion, context);
    }
}

