/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice.sap;

public class SADVersion {
    public static final SADVersion VERSION_10 = new SADVersion(1, 0);
    private final int majorVersion;
    private final int minorVersion;
    private final String versionString;

    private SADVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.versionString = this.majorVersion + "." + this.minorVersion;
    }

    public static SADVersion valueOf(int majorVersion, int minorVersion) {
        if (majorVersion == 1 && minorVersion == 0) {
            return VERSION_10;
        }
        return new SADVersion(majorVersion, minorVersion);
    }

    public static SADVersion valueOf(String version) {
        String[] components = version.split("\\.");
        return SADVersion.valueOf(Integer.valueOf(components[0]), Integer.valueOf(components[1]));
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SADVersion other = (SADVersion)obj;
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        return this.minorVersion == other.minorVersion;
    }
}

