/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice.sap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.joda.time.DateTime;
import se.litsec.swedisheid.opensaml.saml2.signservice.sap.SADVersion;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SAD {
    @JsonProperty(value="sub", required=true)
    private String subject;
    @JsonProperty(value="aud", required=true)
    private String audience;
    @JsonProperty(value="iss", required=true)
    private String issuer;
    @JsonProperty(value="exp", required=true)
    private Integer expiry;
    @JsonProperty(value="iat", required=true)
    private Integer issuedAt;
    @JsonProperty(value="jti", required=true)
    private String jwtId;
    @JsonProperty(value="seElnSadext", required=true)
    private Extension seElnSadext;
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public static SAD fromJson(String json) throws IOException {
        return (SAD)jsonMapper.readValue(json, SAD.class);
    }

    public String toJson() throws IOException {
        return jsonMapper.writeValueAsString((Object)this);
    }

    public byte[] toJsonBytes() throws IOException {
        return jsonMapper.writeValueAsBytes((Object)this);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public Integer getExpiry() {
        return this.expiry;
    }

    @JsonIgnore
    public DateTime getExpiryDateTime() {
        return this.expiry != null ? new DateTime((long)this.expiry.intValue() * 1000L) : null;
    }

    public void setExpiry(Integer expiry) {
        this.expiry = expiry;
    }

    @JsonIgnore
    public void setExpiry(DateTime expiry) {
        this.expiry = expiry != null ? Integer.valueOf((int)(expiry.getMillis() / 1000L)) : null;
    }

    public Integer getIssuedAt() {
        return this.issuedAt;
    }

    @JsonIgnore
    public DateTime getIssuedAtDateTime() {
        return this.issuedAt != null ? new DateTime((long)this.issuedAt.intValue() * 1000L) : null;
    }

    public void setIssuedAt(Integer issuedAt) {
        this.issuedAt = issuedAt;
    }

    @JsonIgnore
    public void setIssuedAt(DateTime issuedAt) {
        this.issuedAt = issuedAt != null ? Integer.valueOf((int)(issuedAt.getMillis() / 1000L)) : null;
    }

    public String getJwtId() {
        return this.jwtId;
    }

    public void setJwtId(String jwtId) {
        this.jwtId = jwtId;
    }

    public Extension getSeElnSadext() {
        return this.seElnSadext;
    }

    public void setSeElnSadext(Extension seElnSadext) {
        this.seElnSadext = seElnSadext;
    }

    public String toString() {
        return String.format("sub='%s', aud='%s', iss='%s', exp='%s', iss='%s', jti='%s', seElnSadext=[%s]", this.subject, this.audience, this.issuer, this.expiry, this.issuedAt, this.jwtId, this.seElnSadext);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.audience == null ? 0 : this.audience.hashCode());
        result = 31 * result + (this.expiry == null ? 0 : this.expiry.hashCode());
        result = 31 * result + (this.issuedAt == null ? 0 : this.issuedAt.hashCode());
        result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
        result = 31 * result + (this.jwtId == null ? 0 : this.jwtId.hashCode());
        result = 31 * result + (this.seElnSadext == null ? 0 : this.seElnSadext.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAD other = (SAD)obj;
        if (this.audience == null ? other.audience != null : !this.audience.equals(other.audience)) {
            return false;
        }
        if (this.expiry == null ? other.expiry != null : !this.expiry.equals(other.expiry)) {
            return false;
        }
        if (this.issuedAt == null ? other.issuedAt != null : !this.issuedAt.equals(other.issuedAt)) {
            return false;
        }
        if (this.issuer == null ? other.issuer != null : !this.issuer.equals(other.issuer)) {
            return false;
        }
        if (this.jwtId == null ? other.jwtId != null : !this.jwtId.equals(other.jwtId)) {
            return false;
        }
        if (this.seElnSadext == null ? other.seElnSadext != null : !this.seElnSadext.equals(other.seElnSadext)) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Extension {
        @JsonProperty(value="ver", defaultValue="1.0")
        private String version;
        @JsonProperty(value="irt", required=true)
        private String inResponseTo;
        @JsonProperty(value="attr", required=true)
        private String attributeName;
        @JsonProperty(value="loa", required=true)
        private String loa;
        @JsonProperty(value="reqid", required=true)
        private String requestID;
        @JsonProperty(value="docs", required=true)
        private Integer numberOfDocuments;

        public String getVersion() {
            return this.version;
        }

        @JsonIgnore
        public SADVersion getSADVersion() {
            return this.version != null ? SADVersion.valueOf(this.version) : SADVersion.VERSION_10;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getInResponseTo() {
            return this.inResponseTo;
        }

        public void setInResponseTo(String inResponseTo) {
            this.inResponseTo = inResponseTo;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public String getLoa() {
            return this.loa;
        }

        public void setLoa(String loa) {
            this.loa = loa;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public Integer getNumberOfDocuments() {
            return this.numberOfDocuments;
        }

        public void setNumberOfDocuments(Integer numberOfDocuments) {
            this.numberOfDocuments = numberOfDocuments;
        }

        public String toString() {
            return String.format("ver='%s', irt='%s', attr='%s', loa='%s', reqid='%s', docs='%d'", this.version, this.inResponseTo, this.attributeName, this.loa, this.requestID, this.numberOfDocuments);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
            result = 31 * result + (this.inResponseTo == null ? 0 : this.inResponseTo.hashCode());
            result = 31 * result + (this.loa == null ? 0 : this.loa.hashCode());
            result = 31 * result + (this.numberOfDocuments == null ? 0 : this.numberOfDocuments.hashCode());
            result = 31 * result + (this.requestID == null ? 0 : this.requestID.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Extension other = (Extension)obj;
            if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
                return false;
            }
            if (this.inResponseTo == null ? other.inResponseTo != null : !this.inResponseTo.equals(other.inResponseTo)) {
                return false;
            }
            if (this.loa == null ? other.loa != null : !this.loa.equals(other.loa)) {
                return false;
            }
            if (this.numberOfDocuments == null ? other.numberOfDocuments != null : !this.numberOfDocuments.equals(other.numberOfDocuments)) {
                return false;
            }
            if (this.requestID == null ? other.requestID != null : !this.requestID.equals(other.requestID)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

