/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.metadata.provider.MetadataProvider;
import se.litsec.opensaml.utils.ObjectUtils;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.EncryptedMessage;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.Message;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.SignMessage;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.SignMessageMimeTypeEnum;

@Deprecated
public class SignMessageFactory {
    private Logger logger = LoggerFactory.getLogger(SignMessageFactory.class);
    private MetadataProvider metadataProvider;
    private MetadataCredentialResolver credentialResolver;
    private String encryptionAlgorithmId = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";

    public SignMessageFactory(MetadataProvider federationMetadataProvider) {
        this.metadataProvider = federationMetadataProvider;
        this.credentialResolver = new MetadataCredentialResolver();
        ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
        keyInfoProviders.add(new DSAKeyValueProvider());
        keyInfoProviders.add(new RSAKeyValueProvider());
        keyInfoProviders.add(new InlineX509DataProvider());
        this.credentialResolver.setKeyInfoCredentialResolver((KeyInfoCredentialResolver)new BasicProviderKeyInfoCredentialResolver(keyInfoProviders));
    }

    public SignMessage create(String message, SignMessageMimeTypeEnum mimeType, Boolean mustShow, String displayEntity, boolean encrypt) throws ResolverException, EncryptionException {
        SignMessage signMessage = (SignMessage)ObjectUtils.createSamlObject(SignMessage.class);
        signMessage.setDisplayEntity(displayEntity);
        signMessage.setMimeType(mimeType);
        signMessage.setMustShow(mustShow);
        Message msg = (Message)ObjectUtils.createXMLObject(Message.class, (QName)Message.DEFAULT_ELEMENT_NAME);
        msg.setContent(message);
        if (encrypt) {
            if (displayEntity == null) {
                throw new IllegalArgumentException("create invoked with no displayEntity. This is required for creating encrypted messages.");
            }
            Credential keyEncryptionCredential = this.getKeyEncryptionCredential(displayEntity);
            if (keyEncryptionCredential == null) {
                throw new EncryptionException("No valid encryption key was found for IdP " + displayEntity);
            }
            EncryptedMessage encryptedMessage = this.encrypt(msg, keyEncryptionCredential);
            signMessage.setEncryptedMessage(encryptedMessage);
        } else {
            signMessage.setMessage(msg);
        }
        return signMessage;
    }

    public Credential getKeyEncryptionCredential(String idpEntityID) {
        try {
            Optional idpMetadata = this.metadataProvider.getIDPSSODescriptor(idpEntityID);
            if (!idpMetadata.isPresent()) {
                this.logger.error("Failed to find metadata for IdP '{}'", (Object)idpEntityID);
                return null;
            }
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new RoleDescriptorCriterion((RoleDescriptor)idpMetadata.get()));
            criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
            Iterable credentials = this.credentialResolver.resolve(criteriaSet);
            Iterator i = credentials.iterator();
            if (i.hasNext()) {
                Credential c = (Credential)i.next();
                this.logger.debug("Found encryption key of type '{}' for IdP '{}'", (Object)c.getCredentialType().getName(), (Object)idpEntityID);
                return c;
            }
            criteriaSet.add((Object)new UsageCriterion(UsageType.UNSPECIFIED), true);
            credentials = this.credentialResolver.resolve(criteriaSet);
            for (Credential c : credentials) {
                if (c.getUsageType() != null && c.getUsageType().equals((Object)UsageType.SIGNING)) continue;
                this.logger.debug("Found encryption key of type '{}' for IdP '{}'", (Object)c.getCredentialType().getName(), (Object)idpEntityID);
                return c;
            }
            this.logger.info("Failed to find valid encryption key for IdP '{}'", (Object)idpEntityID);
            return null;
        }
        catch (ResolverException e) {
            this.logger.error("Failed to find encryption key for IdP '{}' - {}", new Object[]{idpEntityID, e.getMessage(), e});
            return null;
        }
    }

    public EncryptedMessage encrypt(Message message, Credential credential) throws EncryptionException {
        DataEncryptionParameters dataEncryptionParameters = new DataEncryptionParameters();
        dataEncryptionParameters.setAlgorithm(this.encryptionAlgorithmId);
        KeyEncryptionParameters kekParams = new KeyEncryptionParameters();
        kekParams.setEncryptionCredential(credential);
        kekParams.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Encrypter encrypter = new Encrypter();
        EncryptedData encryptedData = encrypter.encryptElement((XMLObject)message, dataEncryptionParameters, kekParams);
        EncryptedMessage encryptedMessage = (EncryptedMessage)ObjectUtils.createSamlObject(EncryptedMessage.class);
        encryptedMessage.setEncryptedData(encryptedData);
        return encryptedMessage;
    }

    public void setEncryptionAlgorithmId(String encryptionAlgorithmId) {
        this.encryptionAlgorithmId = encryptionAlgorithmId;
    }
}

