/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.utils.ObjectUtils;
import se.litsec.opensaml.xmlsec.SAMLObjectEncrypter;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.EncryptedMessage;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.SignMessage;

public class SignMessageEncrypter {
    private Logger log = LoggerFactory.getLogger(SignMessageEncrypter.class);
    private final SAMLObjectEncrypter encrypter;

    public SignMessageEncrypter(SAMLObjectEncrypter encrypter) throws ComponentInitializationException {
        this.encrypter = (SAMLObjectEncrypter)Constraint.isNotNull((Object)encrypter, (String)"encrypter must not be null");
    }

    public void encrypt(SignMessage signMessage, String entityID) throws EncryptionException {
        this.encrypt(signMessage, entityID, null);
    }

    public void encrypt(SignMessage signMessage, String entityID, EncryptionConfiguration configuration) throws EncryptionException {
        Constraint.isNotNull((Object)signMessage, (String)"signMessage must not be null");
        Constraint.isNotNull((Object)entityID, (String)"entityID must not be null");
        if (signMessage.getEncryptedMessage() != null) {
            throw new EncryptionException("signMessage is already encrypted");
        }
        if (signMessage.getMessage() == null) {
            throw new EncryptionException("No Message element available in SignMessage");
        }
        if (signMessage.getDisplayEntity() == null) {
            this.log.debug("Updated SignMessage.DisplayEntity with {}", (Object)entityID);
            signMessage.setDisplayEntity(entityID);
        } else if (!signMessage.getDisplayEntity().equals(entityID)) {
            String msg = String.format("Assigned DisplayEntity (%s) does not match supplied entityID (%s)", signMessage.getDisplayEntity(), entityID);
            throw new EncryptionException(msg);
        }
        EncryptedData encryptedData = this.encrypter.encrypt((XMLObject)signMessage.getMessage(), new SAMLObjectEncrypter.Peer(entityID), configuration);
        EncryptedMessage encryptedMessage = (EncryptedMessage)ObjectUtils.createSamlObject(EncryptedMessage.class);
        encryptedMessage.setEncryptedData(encryptedData);
        signMessage.setMessage(null);
        signMessage.setEncryptedMessage(encryptedMessage);
    }
}

