/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;
import se.litsec.swedisheid.opensaml.saml2.attribute.AttributeConstants;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.Message;

public class SignMessageDigestIssuer {
    private final Logger log = LoggerFactory.getLogger(SignMessageDigestIssuer.class);
    public static final String DEFAULT_DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha256";
    private String defaultDigestMethod;

    public Attribute create(Message message) {
        return this.create(message, null);
    }

    public Attribute create(Message message, EntityDescriptor recipient) {
        MessageDigest messageDigest;
        if (message == null || message.getValue() == null) {
            throw new IllegalArgumentException("Supplied sign message is null or empty");
        }
        String digestAlgorithm = null;
        if (recipient != null) {
            try {
                digestAlgorithm = SignMessageDigestIssuer.getDigestPreference(recipient);
            }
            catch (Exception e) {
                this.log.error("Error during recipient metadata analyze (looking for preferred digest algorithm)", (Throwable)e);
            }
        }
        if (digestAlgorithm == null) {
            digestAlgorithm = this.getDefaultDigestMethod();
        }
        this.log.debug("Using digest algorithm '{}' when issuing signMessageDigest", (Object)digestAlgorithm);
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        AlgorithmDescriptor descriptor = registry.get(digestAlgorithm);
        if (descriptor == null) {
            throw new SecurityException(digestAlgorithm + " is not supported");
        }
        try {
            messageDigest = MessageDigest.getInstance(descriptor.getJCAAlgorithmID());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        byte[] digestValue = messageDigest.digest(message.getContent().getBytes(StandardCharsets.UTF_8));
        String attributeValue = String.format("%s;%s", digestAlgorithm, Base64.getEncoder().encodeToString(digestValue));
        return AttributeConstants.ATTRIBUTE_TEMPLATE_SIGNMESSAGE_DIGEST.createBuilder().value(new String[]{attributeValue}).build();
    }

    public static String getDigestPreference(EntityDescriptor metadata) {
        if (metadata == null) {
            return null;
        }
        List digestMethods = Collections.emptyList();
        SSODescriptor descriptor = MetadataUtils.getSSODescriptor((EntityDescriptor)metadata);
        if (descriptor != null) {
            digestMethods = MetadataUtils.getMetadataExtensions((Extensions)descriptor.getExtensions(), DigestMethod.class);
        }
        if (digestMethods.isEmpty()) {
            digestMethods = MetadataUtils.getMetadataExtensions((Extensions)metadata.getExtensions(), DigestMethod.class);
        }
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        if (!digestMethods.isEmpty()) {
            digestMethods = digestMethods.stream().filter(s -> {
                AlgorithmDescriptor ad = registry.get(s.getAlgorithm());
                if (ad != null) {
                    return AlgorithmDescriptor.AlgorithmType.MessageDigest.equals((Object)ad.getType());
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (digestMethods.isEmpty()) {
            return null;
        }
        return ((DigestMethod)digestMethods.get(0)).getAlgorithm();
    }

    public String getDefaultDigestMethod() {
        return this.defaultDigestMethod != null ? this.defaultDigestMethod : DEFAULT_DIGEST_METHOD;
    }

    public void setDefaultDigestMethod(String defaultDigestMethod) {
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        AlgorithmDescriptor descriptor = registry.get(defaultDigestMethod);
        if (descriptor == null) {
            throw new SecurityException(defaultDigestMethod + " is not supported");
        }
        if (descriptor.getType() != AlgorithmDescriptor.AlgorithmType.MessageDigest) {
            throw new SecurityException(defaultDigestMethod + " is not a valid digest algorithm");
        }
        this.defaultDigestMethod = defaultDigestMethod;
    }
}

