/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice;

import java.util.Collection;
import java.util.List;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.xmlsec.SAMLObjectDecrypter;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.Message;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.SignMessage;
import se.swedenconnect.opensaml.xmlsec.encryption.support.Pkcs11Decrypter;

public class SignMessageDecrypter {
    private Logger logger = LoggerFactory.getLogger(SignMessageDecrypter.class);
    private KeyInfoCredentialResolver keyEncryptionKeyResolver;
    private EncryptedKeyResolver encryptedKeyResolver = new InlineEncryptedKeyResolver();
    private Collection<String> blacklistedAlgorithms;
    private Collection<String> whitelistedAlgorithms;
    private Decrypter decrypter;
    private boolean pkcs11Workaround = false;

    public SignMessageDecrypter(Credential decryptionCredential) {
        this.keyEncryptionKeyResolver = new StaticKeyInfoCredentialResolver(decryptionCredential);
    }

    public SignMessageDecrypter(List<Credential> decryptionCredentials) {
        this.keyEncryptionKeyResolver = new StaticKeyInfoCredentialResolver(decryptionCredentials);
    }

    public SignMessageDecrypter(KeyInfoCredentialResolver keyEncryptionKeyResolver) {
        this.keyEncryptionKeyResolver = keyEncryptionKeyResolver;
    }

    public SignMessageDecrypter(SAMLObjectDecrypter decrypter) {
    }

    public Message decrypt(SignMessage signMessage) throws DecryptionException {
        if (signMessage.getEncryptedMessage() == null && signMessage.getMessage() != null) {
            this.logger.info("No decryption required - SignMessage contains cleartext message");
            return signMessage.getMessage();
        }
        if (signMessage.getEncryptedMessage() == null) {
            String msg = "No message available";
            this.logger.error("No message available");
            throw new DecryptionException("No message available");
        }
        return (Message)this.getDecrypter().decryptData(signMessage.getEncryptedMessage().getEncryptedData());
    }

    private Decrypter getDecrypter() {
        if (this.decrypter == null) {
            DecryptionParameters pars = new DecryptionParameters();
            pars.setKEKKeyInfoCredentialResolver(this.keyEncryptionKeyResolver);
            pars.setEncryptedKeyResolver(this.encryptedKeyResolver);
            pars.setBlacklistedAlgorithms(this.blacklistedAlgorithms);
            pars.setWhitelistedAlgorithms(this.whitelistedAlgorithms);
            this.decrypter = this.pkcs11Workaround ? new Pkcs11Decrypter(pars) : new Decrypter(pars);
            this.decrypter.setRootInNewDocument(true);
        }
        return this.decrypter;
    }

    public void setBlacklistedAlgorithms(Collection<String> blacklistedAlgorithms) {
        this.blacklistedAlgorithms = blacklistedAlgorithms;
    }

    public void setWhitelistedAlgorithms(Collection<String> whitelistedAlgorithms) {
        this.whitelistedAlgorithms = whitelistedAlgorithms;
    }

    public void setPkcs11Workaround(boolean pkcs11Workaround) {
        this.pkcs11Workaround = pkcs11Workaround;
    }
}

