/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.saml2.metadata.provider.MetadataProvider;
import se.litsec.opensaml.utils.ObjectUtils;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.EncryptedMessage;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.Message;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.SignMessage;
import se.litsec.swedisheid.opensaml.saml2.signservice.dss.SignMessageMimeTypeEnum;

public class SignMessageBuilder
extends AbstractSAMLObjectBuilder<SignMessage> {
    private Logger logger = LoggerFactory.getLogger(SignMessageBuilder.class);
    private DataEncryptionParameters dataEncryptionParameters;
    private KeyEncryptionParameters keyEncryptionParameters;

    public static SignMessageBuilder builder() {
        return new SignMessageBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public SignMessage buildEncrypted(Credential keyEncryptionCredential) throws EncryptionException {
        if (((SignMessage)this.object()).getMessage() == null || ((SignMessage)this.object()).getMessage().getValue() == null) {
            throw new EncryptionException("No message to encrypt has been installed");
        }
        String keAlgo = null;
        try {
            KeyEncryptionParameters kep;
            if (this.dataEncryptionParameters == null) {
                this.dataEncryptionParameters = new DataEncryptionParameters();
                this.dataEncryptionParameters.setAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            }
            if (this.keyEncryptionParameters == null) {
                kep = new KeyEncryptionParameters();
                kep.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            } else {
                keAlgo = this.keyEncryptionParameters.getAlgorithm();
                kep = this.keyEncryptionParameters;
            }
            kep.setEncryptionCredential(keyEncryptionCredential);
            Message msg = (Message)ObjectUtils.createXMLObject(Message.class, (QName)Message.DEFAULT_ELEMENT_NAME);
            msg.setValue(((SignMessage)this.object()).getMessage().getValue());
            Encrypter encrypter = new Encrypter();
            EncryptedData encryptedData = encrypter.encryptElement((XMLObject)msg, this.dataEncryptionParameters, kep);
            EncryptedMessage encryptedMessage = (EncryptedMessage)ObjectUtils.createSamlObject(EncryptedMessage.class);
            encryptedMessage.setEncryptedData(encryptedData);
            ((SignMessage)this.object()).setMessage(null);
            ((SignMessage)this.object()).setEncryptedMessage(encryptedMessage);
            SignMessage signMessage = (SignMessage)this.object();
            return signMessage;
        }
        finally {
            if (this.keyEncryptionParameters != null && keAlgo != null) {
                this.keyEncryptionParameters.setAlgorithm(keAlgo);
            }
        }
    }

    @Deprecated
    public SignMessage buildEncrypted(MetadataProvider metadataProvider) throws EncryptionException {
        if (((SignMessage)this.object()).getDisplayEntity() == null) {
            throw new EncryptionException("The displayEntity attribute is required for encrypted messages");
        }
        String idp = ((SignMessage)this.object()).getDisplayEntity();
        try {
            MetadataCredentialResolver credentialResolver = new MetadataCredentialResolver();
            ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
            keyInfoProviders.add(new DSAKeyValueProvider());
            keyInfoProviders.add(new RSAKeyValueProvider());
            keyInfoProviders.add(new InlineX509DataProvider());
            credentialResolver.setKeyInfoCredentialResolver((KeyInfoCredentialResolver)new BasicProviderKeyInfoCredentialResolver(keyInfoProviders));
            Optional idpMetadata = metadataProvider.getIDPSSODescriptor(idp);
            if (!idpMetadata.isPresent()) {
                String msg = String.format("Failed to find metadata for IdP '%s' - can not encrypt message", idp);
                this.logger.error(msg);
                throw new EncryptionException(msg);
            }
            Credential keyEncryptionCredential = null;
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new RoleDescriptorCriterion((RoleDescriptor)idpMetadata.get()));
            criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
            Iterable credentials = credentialResolver.resolve(criteriaSet);
            Iterator i = credentials.iterator();
            if (i.hasNext()) {
                keyEncryptionCredential = (Credential)i.next();
                this.logger.debug("Found encryption key of type '{}' for IdP '{}'", (Object)keyEncryptionCredential.getCredentialType().getName(), (Object)idp);
            }
            if (keyEncryptionCredential == null) {
                criteriaSet.add((Object)new UsageCriterion(UsageType.UNSPECIFIED), true);
                credentials = credentialResolver.resolve(criteriaSet);
                for (Credential c : credentials) {
                    if (c.getUsageType() != null && c.getUsageType().equals((Object)UsageType.SIGNING)) continue;
                    this.logger.debug("Found encryption key of type '{}' for IdP '{}'", (Object)c.getCredentialType().getName(), (Object)idp);
                    keyEncryptionCredential = c;
                    break;
                }
            }
            if (keyEncryptionCredential == null) {
                String msg = String.format("Failed to find valid encryption key for IdP '%s'", idp);
                this.logger.warn(msg);
                throw new EncryptionException(msg);
            }
            return this.buildEncrypted(keyEncryptionCredential);
        }
        catch (ResolverException e) {
            String msg = String.format("Failed to find encryption key for IdP '%s' - %s", idp, e.getMessage());
            this.logger.warn(msg, (Throwable)e);
            throw new EncryptionException(msg);
        }
    }

    @Deprecated
    public SignMessageBuilder dataEncryptionParameters(DataEncryptionParameters parameters) {
        this.dataEncryptionParameters = parameters;
        return this;
    }

    @Deprecated
    public SignMessageBuilder keyEncryptionParameters(KeyEncryptionParameters parameters) {
        this.keyEncryptionParameters = parameters;
        return this;
    }

    public SignMessageBuilder message(String message) {
        Message msg = (Message)ObjectUtils.createXMLObject(Message.class, (QName)Message.DEFAULT_ELEMENT_NAME);
        msg.setContent(message);
        ((SignMessage)this.object()).setMessage(msg);
        return this;
    }

    public SignMessageBuilder displayEntity(String displayEntity) {
        ((SignMessage)this.object()).setDisplayEntity(displayEntity);
        return this;
    }

    public SignMessageBuilder mimeType(SignMessageMimeTypeEnum mimeType) {
        ((SignMessage)this.object()).setMimeType(mimeType);
        return this;
    }

    public SignMessageBuilder mustShow(Boolean mustShow) {
        ((SignMessage)this.object()).setMustShow(mustShow);
        return this;
    }

    protected Class<SignMessage> getObjectType() {
        return SignMessage.class;
    }
}

