/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.signservice;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64URL;
import java.io.IOException;
import java.security.SignatureException;
import java.util.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.opensaml.security.x509.X509Credential;
import se.litsec.swedisheid.opensaml.saml2.signservice.sap.SAD;
import se.litsec.swedisheid.opensaml.saml2.signservice.sap.SADVersion;

public class SADFactory {
    public static final int DEFAULT_VALIDITY_TIME = 300;
    public static final String DEFAULT_USER_ID_ATTRIBUTE_NAME = "urn:oid:1.2.752.29.4.13";
    public static final int DEFAULT_JWT_ID_SIZE = 24;
    public static final String DEFAULT_JWT_SIGNING_ALGORITHM = JWSAlgorithm.RS256.getName();
    private String idpEntityID;
    private X509Credential signingCredential;
    private int validityTime = 300;
    private String userIdAttributeName = "urn:oid:1.2.752.29.4.13";
    private int jwtIdSize = 24;
    private String jwtSigningAlgorithm = DEFAULT_JWT_SIGNING_ALGORITHM;

    public SADFactory(String idpEntityID, X509Credential signingCredential) {
        this.idpEntityID = idpEntityID;
        this.signingCredential = signingCredential;
    }

    public SADBuilder getBuilder() {
        return new SADBuilder(this);
    }

    public String createJwt(SAD sad) throws IOException, SignatureException {
        String encodedSad = Base64.getUrlEncoder().withoutPadding().encodeToString(sad.toJsonBytes());
        try {
            JWSHeader header = new JWSHeader.Builder(new JWSAlgorithm(this.jwtSigningAlgorithm)).type(JOSEObjectType.JWT).build();
            JWSObject signedJwt = new JWSObject(header, new Payload(new Base64URL(encodedSad)));
            signedJwt.sign((JWSSigner)new RSASSASigner(this.signingCredential.getPrivateKey()));
            return signedJwt.serialize();
        }
        catch (JOSEException e) {
            throw new SignatureException("Failed to sign JWT", e);
        }
    }

    public void setValidityTime(int seconds) {
        if (seconds < 1) {
            throw new IllegalArgumentException("seconds must be a positive integer");
        }
        this.validityTime = seconds;
    }

    public void setUserIdAttributeName(String userIdAttributeName) {
        if (userIdAttributeName == null || userIdAttributeName.isEmpty()) {
            throw new IllegalArgumentException("userIdAttributeName must not be null or empty");
        }
        this.userIdAttributeName = userIdAttributeName;
    }

    public void setJwtIdSize(int jwtIdSize) {
        if (jwtIdSize < 12) {
            throw new IllegalArgumentException("The jwtIdSize must be at least 12 characters");
        }
        this.jwtIdSize = jwtIdSize;
    }

    public void setJwtSigningAlgorithm(String jwtSigningAlgorithm) {
        this.jwtSigningAlgorithm = jwtSigningAlgorithm;
    }

    public static class SADBuilder {
        private final SADFactory sadFactory;
        private SAD sad;

        SADBuilder(SADFactory sadFactory) {
            this.sadFactory = sadFactory;
            this.sad = new SAD();
            this.sad.setIssuer(sadFactory.idpEntityID);
            this.sad.setSeElnSadext(new SAD.Extension());
            this.sad.getSeElnSadext().setAttributeName(sadFactory.userIdAttributeName);
        }

        public SAD buildSAD() {
            if (this.sad.getJwtId() == null) {
                this.sad.setJwtId(RandomStringUtils.random((int)this.sadFactory.jwtIdSize, (boolean)true, (boolean)true));
            }
            this.sad.setIssuedAt((int)(System.currentTimeMillis() / 1000L));
            this.sad.setExpiry(this.sad.getIssuedAt() + this.sadFactory.validityTime);
            if (this.sad.getSeElnSadext().getVersion() == null) {
                this.sad.getSeElnSadext().setVersion(SADVersion.VERSION_10.toString());
            }
            return this.sad;
        }

        public String buildJwt() throws IOException, SignatureException {
            return this.sadFactory.createJwt(this.buildSAD());
        }

        public SADBuilder subject(String subject) {
            this.sad.setSubject(subject);
            return this;
        }

        public SADBuilder audience(String audience) {
            this.sad.setAudience(audience);
            return this;
        }

        public SADBuilder jwtId(String jwtId) {
            this.sad.setJwtId(jwtId);
            return this;
        }

        public SADBuilder version(SADVersion version) {
            this.sad.getSeElnSadext().setVersion(version.toString());
            return this;
        }

        public SADBuilder inResponseTo(String irt) {
            this.sad.getSeElnSadext().setInResponseTo(irt);
            return this;
        }

        public SADBuilder loa(String loa) {
            this.sad.getSeElnSadext().setLoa(loa);
            return this;
        }

        public SADBuilder requestID(String requestID) {
            this.sad.getSeElnSadext().setRequestID(requestID);
            return this;
        }

        public SADBuilder numberOfDocuments(int docs) {
            this.sad.getSeElnSadext().setNumberOfDocuments(docs);
            return this;
        }
    }
}

