/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.metadata.entitycategory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import se.litsec.swedisheid.opensaml.saml2.metadata.entitycategory.EntityCategory;
import se.litsec.swedisheid.opensaml.saml2.metadata.entitycategory.EntityCategoryRegistry;
import se.litsec.swedisheid.opensaml.saml2.metadata.entitycategory.EntityCategoryType;
import se.litsec.swedisheid.opensaml.saml2.metadata.entitycategory.ServiceEntityCategory;

public class EntityCategoryRegistryImpl
implements EntityCategoryRegistry {
    private List<EntityCategory> entityCategories;

    public EntityCategoryRegistryImpl(List<EntityCategory> entityCategories) {
        this.entityCategories = entityCategories;
    }

    @Override
    public Optional<EntityCategory> getEntityCategory(String uri) {
        return this.entityCategories.stream().filter(e -> e.getUri().equals(uri)).findFirst();
    }

    @Override
    public List<EntityCategory> getEntityCategories() {
        return Collections.unmodifiableList(this.entityCategories);
    }

    @Override
    public List<ServiceEntityCategory> getServiceEntityCategories() {
        return this.entityCategories.stream().filter(e -> EntityCategoryType.SERVICE_ENTITY.equals((Object)e.getType())).map(ServiceEntityCategory.class::cast).collect(Collectors.toList());
    }
}

