/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.metadata.entitycategory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import se.litsec.opensaml.saml2.attribute.AttributeBuilder;
import se.litsec.opensaml.saml2.attribute.AttributeUtils;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;

public class EntityCategoryMetadataHelper {
    public static final String ENTITY_CATEGORY_ATTRIBUTE_NAME = "http://macedir.org/entity-category";

    public static Attribute createEntityCategoryAttribute(String ... categories) {
        if (categories == null || categories.length == 0) {
            return null;
        }
        return EntityCategoryMetadataHelper.createEntityCategoryAttribute(Arrays.asList(categories));
    }

    public static Attribute createEntityCategoryAttribute(List<String> categories) {
        if (categories == null || categories.isEmpty()) {
            return null;
        }
        AttributeBuilder builder = AttributeBuilder.builder((String)ENTITY_CATEGORY_ATTRIBUTE_NAME).nameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        categories.stream().forEach(xva$0 -> builder.value(new String[]{xva$0}));
        return builder.build();
    }

    public static List<String> getEntityCategories(EntityDescriptor ed) {
        Optional entityAttributes = MetadataUtils.getEntityAttributes((EntityDescriptor)ed);
        if (!entityAttributes.isPresent()) {
            return Collections.emptyList();
        }
        List attrs = ((EntityAttributes)entityAttributes.get()).getAttributes().stream().filter(a -> a.getName().equals(ENTITY_CATEGORY_ATTRIBUTE_NAME)).collect(Collectors.toList());
        ArrayList<String> categories = new ArrayList<String>();
        for (Attribute attr : attrs) {
            categories.addAll(AttributeUtils.getAttributeStringValues((Attribute)attr));
        }
        return categories;
    }

    private EntityCategoryMetadataHelper() {
    }
}

