/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.discovery;

import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.swedisheid.opensaml.saml2.metadata.entitycategory.EntityCategoryType;

public class SwedishEidDiscoveryMatchingRules {
    private static final Logger log = LoggerFactory.getLogger(SwedishEidDiscoveryMatchingRules.class);

    public static boolean isMatch(Collection<String> consumingService, Collection<String> providingService) {
        if (!SwedishEidDiscoveryMatchingRules.isServiceEntityMatch(consumingService, providingService)) {
            return false;
        }
        if (!SwedishEidDiscoveryMatchingRules.isServiceContractMatch(consumingService, providingService)) {
            return false;
        }
        return SwedishEidDiscoveryMatchingRules.isServicePropertyMatch(consumingService, providingService);
    }

    public static boolean isServiceEntityMatch(Collection<String> consumingService, Collection<String> providingService) {
        Collection csServiceEntityCategories = consumingService.stream().filter(c -> EntityCategoryType.isType(c, EntityCategoryType.SERVICE_ENTITY)).collect(Collectors.toList());
        if (!csServiceEntityCategories.isEmpty()) {
            String matchingServiceEntityCategory = csServiceEntityCategories.stream().filter(c -> providingService.contains(c)).findFirst().orElse(null);
            if (matchingServiceEntityCategory == null) {
                log.debug("The providing service did not declare any of the service entity categories declared by the consuming service ({}) -> no match", (Object)csServiceEntityCategories);
                return false;
            }
            log.debug("Consuming service declared {} which is also declared by providing service -> service entity category match", (Object)matchingServiceEntityCategory);
        } else {
            log.debug("No Service entity entity categories declared by the consuming service -> match");
        }
        return true;
    }

    public static boolean isServiceContractMatch(Collection<String> consumingService, Collection<String> providingService) {
        Collection psServiceContractCategories = providingService.stream().filter(c -> EntityCategoryType.isType(c, EntityCategoryType.SERVICE_CONTRACT)).collect(Collectors.toList());
        if (!psServiceContractCategories.isEmpty()) {
            String matchingServiceContractCategory = psServiceContractCategories.stream().filter(c -> consumingService.contains(c)).findFirst().orElse(null);
            if (matchingServiceContractCategory == null) {
                log.debug("The providing service declared service contract category/categories {}. The consuming service did not declare any of these -> no match", (Object)psServiceContractCategories);
                return false;
            }
            log.debug("Providing service declared {} which is also declared by consuming service -> service contract match", (Object)matchingServiceContractCategory);
        } else {
            log.debug("No service contract categories defined by providing service -> match");
        }
        return true;
    }

    public static boolean isServicePropertyMatch(Collection<String> consumingService, Collection<String> providingService) {
        Collection csServicePropertyCategories = consumingService.stream().filter(c -> EntityCategoryType.isType(c, EntityCategoryType.SERVICE_PROPERTY)).collect(Collectors.toList());
        if (!csServicePropertyCategories.isEmpty()) {
            if (!csServicePropertyCategories.stream().allMatch(c -> providingService.contains(c))) {
                log.debug("Consuming service declared the service property category/categories {} - Not all are defined by providing service -> no match", (Object)csServicePropertyCategories);
                return false;
            }
            log.debug("Consuming service declared the category/categories {} which are also declared by providing service -> service property match", (Object)csServicePropertyCategories);
        } else {
            log.debug("No service property categories defined by consuming service -> match");
        }
        return true;
    }
}

