/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.swedisheid.opensaml.saml2.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.attribute.AttributeTemplate;
import se.litsec.swedisheid.opensaml.saml2.attribute.AttributeSet;
import se.litsec.swedisheid.opensaml.saml2.attribute.AttributesValidationException;

public class AttributeSetImpl
implements AttributeSet {
    private static final Logger logger = LoggerFactory.getLogger(AttributeSetImpl.class);
    private String identifier;
    private String uri;
    private String friendlyName;
    private List<AttributeTemplate> requiredAttributes;
    private List<AttributeTemplate> recommendedAttributes;

    public AttributeSetImpl() {
    }

    public AttributeSetImpl(String identifier, String uri, String friendlyName, AttributeTemplate[] requiredAttributes, AttributeTemplate[] recommendedAttributes) {
        this.setIdentifier(identifier);
        this.setUri(uri);
        this.setFriendlyName(friendlyName);
        this.setRequiredAttributes(requiredAttributes);
        this.setRecommendedAttributes(recommendedAttributes);
    }

    @Override
    public void validateAttributes(Assertion assertion, List<RequestedAttribute> explicitlyRequestedAttributes) throws AttributesValidationException {
        Optional<Attribute> found;
        logger.trace("Validating the attributes from assertion '{}' against attribute set '{}' ({}) ...", new Object[]{assertion.getID(), this.identifier, this.uri});
        List attributes = ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes();
        for (AttributeTemplate requiredAttribute : this.requiredAttributes) {
            found = attributes.stream().filter(a -> requiredAttribute.getName().equals(a.getName())).findFirst();
            if (found.isPresent()) continue;
            String msg = String.format("Attribute '%s' (%s) is required according to the attribute set '%s' (%s) but is not included in assertion '%s'", requiredAttribute.getName(), requiredAttribute.getFriendlyName(), this.identifier, this.uri, assertion.getID());
            logger.error(msg);
            throw new AttributesValidationException(msg);
        }
        logger.debug("All requested attributes according to attribute profile '{}' ({}) was received in assertion '{}'", new Object[]{this.identifier, this.uri, assertion.getID()});
        if (explicitlyRequestedAttributes != null) {
            for (RequestedAttribute ra : explicitlyRequestedAttributes) {
                found = attributes.stream().filter(a -> ra.getName().equals(a.getName())).findFirst();
                if (!found.isPresent()) {
                    if (ra.isRequired() != null && ra.isRequired().booleanValue()) {
                        String msg = String.format("Attribute '%s' (%s) is listed a RequestedAttribute with isRequired=true in SP metadata, but does not appear in assertion '%s'", ra.getName(), ra.getFriendlyName(), assertion.getID());
                        logger.error(msg);
                        throw new AttributesValidationException(msg);
                    }
                    logger.info("Attribute '{}' ({}) is listed a requested, but not required, in SP metadata. It does not appear in assertion '{}'", new Object[]{ra.getName(), ra.getFriendlyName(), assertion.getID()});
                    continue;
                }
                logger.debug("Attribute '{}' ({}) was explicitly requested in SP metadata and it appears in assertion '{}'", new Object[]{ra.getName(), ra.getFriendlyName(), assertion.getID()});
            }
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public AttributeTemplate[] getRequiredAttributes() {
        return this.requiredAttributes != null ? this.requiredAttributes.toArray(new AttributeTemplate[0]) : new AttributeTemplate[]{};
    }

    @Override
    public AttributeTemplate[] getRecommendedAttributes() {
        return this.recommendedAttributes != null ? this.recommendedAttributes.toArray(new AttributeTemplate[0]) : new AttributeTemplate[]{};
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setRequiredAttributes(AttributeTemplate[] requiredAttributes) {
        this.requiredAttributes = requiredAttributes != null ? Arrays.asList(requiredAttributes) : Collections.emptyList();
    }

    public void setRecommendedAttributes(AttributeTemplate[] recommendedAttributes) {
        this.recommendedAttributes = recommendedAttributes != null ? Arrays.asList(recommendedAttributes) : Collections.emptyList();
    }
}

