/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.xmlsec;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;
import se.litsec.opensaml.saml2.metadata.provider.MetadataProvider;
import se.swedenconnect.opensaml.xmlsec.ExtendedSAMLMetadataEncryptionParametersResolver;
import se.swedenconnect.opensaml.xmlsec.config.ExtendedDefaultSecurityConfigurationBootstrap;

public class SAMLObjectEncrypter {
    private Logger log = LoggerFactory.getLogger(SAMLObjectEncrypter.class);
    private MetadataProvider metadataProvider;
    private ExtendedSAMLMetadataEncryptionParametersResolver encryptionParameterResolver;
    private EncryptionConfiguration defaultEncryptionConfiguration;
    private Encrypter encrypter = new Encrypter();

    public SAMLObjectEncrypter() throws ComponentInitializationException {
        this(null);
    }

    public SAMLObjectEncrypter(MetadataProvider metadataProvider) throws ComponentInitializationException {
        if (metadataProvider != null) {
            this.metadataProvider = metadataProvider;
        }
        this.defaultEncryptionConfiguration = SecurityConfigurationSupport.getGlobalEncryptionConfiguration();
        if (this.defaultEncryptionConfiguration == null) {
            this.defaultEncryptionConfiguration = ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        }
        MetadataCredentialResolver credentialResolver = new MetadataCredentialResolver();
        credentialResolver.setKeyInfoCredentialResolver(DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        credentialResolver.initialize();
        this.encryptionParameterResolver = new ExtendedSAMLMetadataEncryptionParametersResolver(credentialResolver);
        this.encryptionParameterResolver.setMergeMetadataRSAOAEPParametersWithConfig(true);
        this.encryptionParameterResolver.setUseKeyAgreementDefaults(true);
        this.encryptionParameterResolver.setAutoGenerateDataEncryptionCredential(true);
    }

    public EncryptedData encrypt(XMLObject xmlObject, Peer peer) throws EncryptionException {
        return this.encrypt(xmlObject, peer, this.defaultEncryptionConfiguration);
    }

    public EncryptedData encrypt(XMLObject xmlObject, Peer peer, EncryptionConfiguration configuration) throws EncryptionException {
        EntityDescriptor peerMetadata;
        EncryptionParameters parameters;
        Constraint.isNotNull((Object)xmlObject, (String)"xmlObject must not be null");
        Constraint.isNotNull((Object)peer, (String)"peer must not be null");
        if (configuration == null) {
            configuration = this.defaultEncryptionConfiguration;
        }
        if ((parameters = this.getEncryptionParameters(peerMetadata = this.getPeerMetadata(peer), configuration)) == null) {
            throw new EncryptionException(String.format("No encryption credentials found for '%s'", peer.getEntityID()));
        }
        DataEncryptionParameters dataEncryptionParameters = new DataEncryptionParameters(parameters);
        KeyEncryptionParameters kekParams = new KeyEncryptionParameters(parameters, peer.getEntityID());
        return this.encrypter.encryptElement(xmlObject, dataEncryptionParameters, kekParams);
    }

    private EntityDescriptor getPeerMetadata(Peer peer) throws EncryptionException {
        EntityDescriptor peerMetadata = peer.getMetadata();
        if (peerMetadata != null) {
            return peerMetadata;
        }
        if (this.metadataProvider == null) {
            throw new EncryptionException("Peer metadata is not available - no metadataProvider has been configured");
        }
        try {
            return this.metadataProvider.getEntityDescriptor(peer.getEntityID()).orElseThrow(() -> new EncryptionException(String.format("Metadata for '%s' could not be found", peer.getMetadata())));
        }
        catch (ResolverException e) {
            throw new EncryptionException("Failed to locate peer metadata", (Exception)((Object)e));
        }
    }

    private EncryptionParameters getEncryptionParameters(EntityDescriptor metadata, EncryptionConfiguration configuration) throws EncryptionException {
        SSODescriptor descriptor = MetadataUtils.getSSODescriptor(metadata);
        if (descriptor == null) {
            throw new EncryptionException("Bad peer metadata - no SSO descriptor available");
        }
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new RoleDescriptorCriterion((RoleDescriptor)descriptor));
        criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        criteriaSet.add((Object)new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{configuration}));
        criteriaSet.add((Object)new EncryptionOptionalCriterion(false));
        try {
            return this.encryptionParameterResolver.resolveSingle(criteriaSet);
        }
        catch (ResolverException e) {
            this.log.error("Error during resolve of encryption parameters", (Throwable)e);
            throw new EncryptionException("Error during resolve of encryption parameters", (Exception)((Object)e));
        }
    }

    public void setEncrypter(Encrypter encrypter) {
        if (encrypter != null) {
            this.encrypter = encrypter;
        }
    }

    public void setDefaultEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        if (encryptionConfiguration != null) {
            this.defaultEncryptionConfiguration = encryptionConfiguration;
        }
    }

    public void setAlgorithmRegistry(AlgorithmRegistry algorithmRegistry) {
        if (algorithmRegistry != null) {
            this.encryptionParameterResolver.setAlgorithmRegistry(algorithmRegistry);
        }
    }

    public static class Peer {
        private String entityID;
        private EntityDescriptor metadata;

        public Peer(String entityID) {
            Constraint.isNotEmpty((String)entityID, (String)"entityID must be set");
            this.entityID = entityID;
        }

        public Peer(EntityDescriptor metadata) {
            Constraint.isNotNull((Object)metadata, (String)"metadata must not be null");
            this.metadata = metadata;
            this.entityID = metadata.getEntityID();
        }

        public String getEntityID() {
            return this.entityID;
        }

        public EntityDescriptor getMetadata() {
            return this.metadata;
        }
    }
}

