/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.xmlsec;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.EncryptedElementType;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import se.swedenconnect.opensaml.xmlsec.encryption.support.DecryptionUtils;
import se.swedenconnect.opensaml.xmlsec.encryption.support.Pkcs11Decrypter;

public class SAMLObjectDecrypter {
    private Decrypter decrypter;
    private DecryptionParameters parameters;
    private boolean pkcs11Workaround = false;
    private boolean pkcs11testMode = false;

    public SAMLObjectDecrypter(Credential decryptionCredential) {
        this(Collections.singletonList(decryptionCredential));
    }

    public SAMLObjectDecrypter(List<Credential> decryptionCredentials) {
        Constraint.isNotEmpty(decryptionCredentials, (String)"At least one credential must be supplied to SAMLObjectDecrypter");
        this.parameters = DecryptionUtils.createDecryptionParameters((Credential[])((Credential[])decryptionCredentials.stream().toArray(Credential[]::new)));
        this.parameters.setBlacklistedAlgorithms(Collections.emptyList());
        this.parameters.setWhitelistedAlgorithms(Collections.emptyList());
    }

    public SAMLObjectDecrypter(DecryptionParameters decryptionParameters) {
        this.parameters = new DecryptionParameters();
        this.parameters.setDataKeyInfoCredentialResolver(decryptionParameters.getDataKeyInfoCredentialResolver());
        this.parameters.setKEKKeyInfoCredentialResolver(decryptionParameters.getKEKKeyInfoCredentialResolver());
        this.parameters.setEncryptedKeyResolver(decryptionParameters.getEncryptedKeyResolver());
        this.parameters.setBlacklistedAlgorithms(decryptionParameters.getBlacklistedAlgorithms());
        this.parameters.setWhitelistedAlgorithms(decryptionParameters.getWhitelistedAlgorithms());
    }

    public SAMLObjectDecrypter(DecryptionConfiguration decryptionConfiguration) {
        this.parameters = new DecryptionParameters();
        this.parameters.setDataKeyInfoCredentialResolver(decryptionConfiguration.getDataKeyInfoCredentialResolver());
        this.parameters.setKEKKeyInfoCredentialResolver(decryptionConfiguration.getKEKKeyInfoCredentialResolver());
        this.parameters.setEncryptedKeyResolver(decryptionConfiguration.getEncryptedKeyResolver());
        this.parameters.setBlacklistedAlgorithms(decryptionConfiguration.getBlacklistedAlgorithms());
        this.parameters.setWhitelistedAlgorithms(decryptionConfiguration.getWhitelistedAlgorithms());
    }

    public <T extends XMLObject, E extends EncryptedElementType> T decrypt(E encryptedObject, Class<T> destinationClass) throws DecryptionException {
        if (encryptedObject.getEncryptedData() == null) {
            throw new DecryptionException("Object contains no encrypted data");
        }
        return this.decrypt(encryptedObject.getEncryptedData(), destinationClass);
    }

    public <T extends XMLObject> T decrypt(EncryptedData encryptedData, Class<T> destinationClass) throws DecryptionException {
        XMLObject object = this.getDecrypter().decryptData(encryptedData);
        if (!destinationClass.isInstance(object)) {
            throw new DecryptionException(String.format("Decrypted object can not be cast to %s - is %s", destinationClass.getSimpleName(), object.getClass().getSimpleName()));
        }
        return (T)((XMLObject)destinationClass.cast(object));
    }

    private synchronized Decrypter getDecrypter() {
        if (this.decrypter == null) {
            if (this.pkcs11Workaround) {
                Pkcs11Decrypter p11Decrypter = new Pkcs11Decrypter(this.parameters);
                p11Decrypter.setTestMode(this.pkcs11testMode);
                this.decrypter = p11Decrypter;
            } else {
                this.decrypter = new Decrypter(this.parameters);
            }
            this.decrypter.setRootInNewDocument(true);
        }
        return this.decrypter;
    }

    public void setBlacklistedAlgorithms(Collection<String> blacklistedAlgorithms) {
        if (this.decrypter != null) {
            throw new IllegalStateException("Object has already been initialized");
        }
        this.parameters.setBlacklistedAlgorithms(blacklistedAlgorithms);
    }

    public void setWhitelistedAlgorithms(Collection<String> whitelistedAlgorithms) {
        if (this.decrypter != null) {
            throw new IllegalStateException("Object has already been initialized");
        }
        this.parameters.setWhitelistedAlgorithms(whitelistedAlgorithms);
    }

    public void setPkcs11Workaround(boolean pkcs11Workaround) {
        this.pkcs11Workaround = pkcs11Workaround;
    }

    public void setPkcs11testMode(boolean pkcs11testMode) {
        this.pkcs11testMode = pkcs11testMode;
    }
}

