/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.xmlsec;

import com.google.common.base.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collection;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedType;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLCipherInput;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import sun.security.rsa.RSAPadding;

@Deprecated
public class ExtendedDecrypter
extends Decrypter {
    private final Logger log = LoggerFactory.getLogger(ExtendedDecrypter.class);
    private boolean testMode = false;
    private int keyLength = -1;
    private KeyInfoCredentialResolver _kekResolver;

    public ExtendedDecrypter(DecryptionParameters params) {
        super(params);
        this._kekResolver = params.getKEKKeyInfoCredentialResolver();
    }

    public ExtendedDecrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver) {
        super(newResolver, newKEKResolver, newEncKeyResolver);
        this._kekResolver = newKEKResolver;
    }

    public ExtendedDecrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver, Collection<String> whitelistAlgos, Collection<String> blacklistAlgos) {
        super(newResolver, newKEKResolver, newEncKeyResolver, whitelistAlgos, blacklistAlgos);
        this._kekResolver = newKEKResolver;
    }

    public void init() {
        if (this._kekResolver != null) {
            CriteriaSet cs = new CriteriaSet();
            try {
                PublicKey pubKey;
                Credential cred = (Credential)this._kekResolver.resolveSingle((Object)cs);
                if (cred != null && (pubKey = cred.getPublicKey()) != null) {
                    this.keyLength = ExtendedDecrypter.getKeyLength(pubKey);
                }
            }
            catch (ResolverException resolverException) {
                // empty catch block
            }
            if (this.keyLength <= 0) {
                this.log.error("Failed to resolve any certificates for key decryption");
            }
        }
    }

    public Key decryptKey(EncryptedKey encryptedKey, String algorithm, Key kek) throws DecryptionException {
        org.apache.xml.security.encryption.EncryptedKey encKey;
        XMLCipher xmlCipher;
        if (!this.testMode && kek != null && !"sun.security.pkcs11.P11Key$P11PrivateKey".equals(kek.getClass().getName())) {
            return super.decryptKey(encryptedKey, algorithm, kek);
        }
        if (!AlgorithmSupport.isRSAOAEP((String)encryptedKey.getEncryptionMethod().getAlgorithm())) {
            return super.decryptKey(encryptedKey, algorithm, kek);
        }
        if (Strings.isNullOrEmpty((String)algorithm)) {
            this.log.error("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
            throw new DecryptionException("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
        }
        this.validateAlgorithms(encryptedKey);
        try {
            this.checkAndMarshall((XMLObject)encryptedKey);
        }
        catch (DecryptionException e) {
            this.log.error("Error marshalling EncryptedKey for decryption", (Throwable)e);
            throw e;
        }
        this.preProcessEncryptedKey(encryptedKey, algorithm, kek);
        try {
            xmlCipher = this.getJCAProviderName() != null ? XMLCipher.getProviderInstance((String)this.getJCAProviderName()) : XMLCipher.getInstance();
            xmlCipher.init(4, kek);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error initialzing cipher instance on key decryption", (Throwable)e);
            throw new DecryptionException("Error initialzing cipher instance on key decryption", (Exception)((Object)e));
        }
        try {
            Element targetElement = encryptedKey.getDOM();
            encKey = xmlCipher.loadEncryptedKey(targetElement.getOwnerDocument(), targetElement);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error when loading library native encrypted key representation", (Throwable)e);
            throw new DecryptionException("Error when loading library native encrypted key representation", (Exception)((Object)e));
        }
        try {
            Key key = this.customizedDecryptKey(encKey, algorithm, kek);
            if (key == null) {
                throw new DecryptionException("Key could not be decrypted");
            }
            return key;
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error decrypting encrypted key", (Throwable)e);
            throw new DecryptionException("Error decrypting encrypted key", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DecryptionException("Probable runtime exception on decryption:" + e.getMessage(), e);
        }
    }

    private Key customizedDecryptKey(org.apache.xml.security.encryption.EncryptedKey encryptedKey, String algorithm, Key kek) throws XMLEncryptionException {
        byte[] encryptedBytes = new XMLCipherInput((EncryptedType)encryptedKey).getBytes();
        try {
            String provider = this.getJCAProviderName();
            Cipher c = provider != null ? Cipher.getInstance("RSA/ECB/NoPadding", provider) : Cipher.getInstance("RSA/ECB/NoPadding");
            c.init(2, kek);
            byte[] paddedPlainText = c.doFinal(encryptedBytes);
            if (paddedPlainText.length < this.keyLength / 8) {
                byte[] tmp = new byte[this.keyLength / 8];
                System.arraycopy(paddedPlainText, 0, tmp, tmp.length - paddedPlainText.length, paddedPlainText.length);
                paddedPlainText = tmp;
            }
            EncryptionMethod encMethod = encryptedKey.getEncryptionMethod();
            OAEPParameterSpec oaepParameters = this.constructOAEPParameters(encMethod.getAlgorithm(), encMethod.getDigestAlgorithm(), encMethod.getMGFAlgorithm(), encMethod.getOAEPparams());
            RSAPadding padding = RSAPadding.getInstance(4, this.keyLength / 8, new SecureRandom(), oaepParameters);
            byte[] secretKeyBytes = padding.unpad(paddedPlainText);
            String jceKeyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
            return new SecretKeySpec(secretKeyBytes, jceKeyAlgorithm);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new XMLEncryptionException((Exception)e);
        }
    }

    private OAEPParameterSpec constructOAEPParameters(String encryptionAlgorithm, String digestAlgorithm, String mgfAlgorithm, byte[] oaepParams) {
        String jceDigestAlgorithm = "SHA-1";
        if (digestAlgorithm != null) {
            jceDigestAlgorithm = JCEMapper.translateURItoJCEID((String)digestAlgorithm);
        }
        PSource.PSpecified pSource = PSource.PSpecified.DEFAULT;
        if (oaepParams != null) {
            pSource = new PSource.PSpecified(oaepParams);
        }
        MGF1ParameterSpec mgfParameterSpec = new MGF1ParameterSpec("SHA-1");
        if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptionAlgorithm)) {
            if ("http://www.w3.org/2009/xmlenc11#mgf1sha256".equals(mgfAlgorithm)) {
                mgfParameterSpec = new MGF1ParameterSpec("SHA-256");
            } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha384".equals(mgfAlgorithm)) {
                mgfParameterSpec = new MGF1ParameterSpec("SHA-384");
            } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha512".equals(mgfAlgorithm)) {
                mgfParameterSpec = new MGF1ParameterSpec("SHA-512");
            }
        }
        return new OAEPParameterSpec(jceDigestAlgorithm, "MGF1", mgfParameterSpec, pSource);
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    private static int getKeyLength(PublicKey pk) {
        int len = -1;
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapub = (RSAPublicKey)pk;
            len = rsapub.getModulus().bitLength();
        } else if (pk instanceof ECPublicKey) {
            ECPublicKey ecpriv = (ECPublicKey)pk;
            ECParameterSpec spec = ecpriv.getParams();
            len = spec != null ? spec.getOrder().bitLength() : 0;
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsapub = (DSAPublicKey)pk;
            len = dsapub.getParams() != null ? dsapub.getParams().getP().bitLength() : dsapub.getY().bitLength();
        }
        return len;
    }
}

