/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.utils.spring;

import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class X509CertificateFactoryBean
extends AbstractFactoryBean<X509Certificate> {
    protected Resource resource;
    private static CertificateFactory factory = null;

    public X509CertificateFactoryBean(Resource resource) {
        this.resource = resource;
    }

    protected X509Certificate createInstance() throws Exception {
        return (X509Certificate)factory.generateCertificate(this.resource.getInputStream());
    }

    public Class<?> getObjectType() {
        return X509Certificate.class;
    }

    static {
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
    }
}

