/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.utils.spring;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.security.auth.DestroyFailedException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class PrivateKeyEntryFactoryBean
extends AbstractFactoryBean<KeyStore.PrivateKeyEntry> {
    protected Resource storeLocation;
    protected char[] storePassword;
    protected String storeType;
    protected String alias;
    protected char[] keyPassword;

    public PrivateKeyEntryFactoryBean(Resource storeLocation, char[] storePassword) {
        this(storeLocation, storePassword, KeyStore.getDefaultType());
    }

    public PrivateKeyEntryFactoryBean(Resource storeLocation, char[] storePassword, String storeType) {
        this.storeLocation = storeLocation;
        this.storePassword = storePassword != null ? Arrays.copyOf(storePassword, storePassword.length) : new char[]{};
        this.storeType = storeType;
    }

    public PrivateKeyEntryFactoryBean(Resource storeLocation, char[] storePassword, String alias, char[] keyPassword) {
        this(storeLocation, storePassword, KeyStore.getDefaultType(), alias, keyPassword);
    }

    public PrivateKeyEntryFactoryBean(Resource storeLocation, char[] storePassword, String storeType, String alias, char[] keyPassword) {
        this(storeLocation, storePassword, storeType);
        this.alias = alias;
        this.keyPassword = keyPassword != null ? Arrays.copyOf(keyPassword, keyPassword.length) : new char[]{};
    }

    protected KeyStore.PrivateKeyEntry createInstance() throws Exception {
        try {
            KeyStore keystore = KeyStore.getInstance(this.storeType);
            keystore.load(this.storeLocation.getInputStream(), this.storePassword);
            if (this.alias != null) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(this.alias, new KeyStore.PasswordProtection(this.keyPassword));
                return privateKeyEntry;
            }
            Enumeration<String> aliases = keystore.aliases();
            boolean triedUnlockUsingKeystorePw = false;
            while (aliases.hasMoreElements()) {
                String keyAlias = aliases.nextElement();
                if (!keystore.entryInstanceOf(keyAlias, KeyStore.PrivateKeyEntry.class)) continue;
                char[] pw = this.keyPassword != null ? this.keyPassword : this.storePassword;
                try {
                    KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(keyAlias, new KeyStore.PasswordProtection(pw));
                    return privateKeyEntry;
                }
                catch (UnrecoverableKeyException e) {
                    if (this.keyPassword == null) {
                        triedUnlockUsingKeystorePw = true;
                        continue;
                    }
                    throw e;
                }
            }
            if (triedUnlockUsingKeystorePw) {
                throw new GeneralSecurityException("No private key entry found in keystore that could be unlocked with password of keystore");
            }
            throw new GeneralSecurityException("No private key entry found in keystore");
        }
        finally {
            if (this.isSingleton()) {
                Arrays.fill(this.storePassword, '\u0000');
                if (this.keyPassword != null) {
                    Arrays.fill(this.keyPassword, '\u0000');
                }
            }
        }
    }

    public Class<? extends KeyStore.PrivateKeyEntry> getObjectType() {
        return KeyStore.PrivateKeyEntry.class;
    }

    public void destroy() throws Exception {
        super.destroy();
        Arrays.fill(this.storePassword, '\u0000');
        if (this.keyPassword != null) {
            Arrays.fill(this.keyPassword, '\u0000');
        }
    }

    protected void destroyInstance(KeyStore.PrivateKeyEntry instance) throws Exception {
        if (instance != null && instance.getPrivateKey() != null) {
            try {
                instance.getPrivateKey().destroy();
            }
            catch (SecurityException | DestroyFailedException exception) {
                // empty catch block
            }
        }
    }
}

