/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.utils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureSigningParametersResolver;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;

public class SignatureUtils {
    public static SignatureSigningConfiguration getSignaturePreferences(EntityDescriptor metadata) {
        if (metadata == null) {
            return null;
        }
        List<Object> signingMethods = Collections.emptyList();
        List<Object> digestMethods = Collections.emptyList();
        SSODescriptor descriptor = MetadataUtils.getSSODescriptor(metadata);
        if (descriptor != null) {
            signingMethods = MetadataUtils.getMetadataExtensions(descriptor.getExtensions(), SigningMethod.class);
            digestMethods = MetadataUtils.getMetadataExtensions(descriptor.getExtensions(), DigestMethod.class);
        }
        if (signingMethods.isEmpty()) {
            signingMethods = MetadataUtils.getMetadataExtensions(metadata.getExtensions(), SigningMethod.class);
        }
        if (digestMethods.isEmpty()) {
            digestMethods = MetadataUtils.getMetadataExtensions(metadata.getExtensions(), DigestMethod.class);
        }
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        if (!signingMethods.isEmpty()) {
            signingMethods = signingMethods.stream().filter(s -> {
                AlgorithmDescriptor ad = registry.get(s.getAlgorithm());
                if (ad != null) {
                    return AlgorithmDescriptor.AlgorithmType.Signature.equals((Object)ad.getType());
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (!digestMethods.isEmpty()) {
            digestMethods = digestMethods.stream().filter(s -> {
                AlgorithmDescriptor ad = registry.get(s.getAlgorithm());
                if (ad != null) {
                    return AlgorithmDescriptor.AlgorithmType.MessageDigest.equals((Object)ad.getType());
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (signingMethods.isEmpty() && digestMethods.isEmpty()) {
            return null;
        }
        BasicSignatureSigningConfiguration config = new BasicSignatureSigningConfiguration();
        if (!signingMethods.isEmpty()) {
            config.setSignatureAlgorithms(signingMethods.stream().map(SigningMethod::getAlgorithm).collect(Collectors.toList()));
        }
        if (!digestMethods.isEmpty()) {
            config.setSignatureReferenceDigestMethods(digestMethods.stream().map(DigestMethod::getAlgorithm).collect(Collectors.toList()));
        }
        return config;
    }

    @Deprecated
    public static <T extends SignableSAMLObject> void sign(T object, Credential signingCredentials) throws SignatureException {
        SignatureUtils.sign(object, signingCredentials, SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
    }

    public static <T extends SignableSAMLObject> void sign(T object, Credential signingCredentials, SignatureSigningConfiguration config, EntityDescriptor recipientMetadata) throws SignatureException {
        SignatureSigningConfiguration peerConfig = SignatureUtils.getSignaturePreferences(recipientMetadata);
        if (config == null) {
            config = SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration();
        }
        SignatureSigningConfiguration[] configs = new SignatureSigningConfiguration[1 + (peerConfig != null ? 1 : 0)];
        int pos = 0;
        if (peerConfig != null) {
            configs[pos++] = peerConfig;
        }
        configs[pos] = config;
        SignatureUtils.sign(object, signingCredentials, configs);
    }

    public static <T extends SignableSAMLObject> void sign(T object, Credential signingCredentials, SignatureSigningConfiguration ... configs) throws SignatureException {
        if (configs == null || configs.length == 0) {
            configs = new SignatureSigningConfiguration[]{SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration()};
        }
        try {
            object.setSignature(null);
            BasicSignatureSigningConfiguration signatureCreds = new BasicSignatureSigningConfiguration();
            signatureCreds.setSigningCredentials(Collections.singletonList(signingCredentials));
            BasicSignatureSigningParametersResolver signatureParametersResolver = new BasicSignatureSigningParametersResolver();
            SignatureSigningConfiguration[] criteriaConfig = new SignatureSigningConfiguration[configs.length + 1];
            System.arraycopy(configs, 0, criteriaConfig, 0, configs.length);
            criteriaConfig[configs.length] = signatureCreds;
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new SignatureSigningConfigurationCriterion(criteriaConfig)});
            SignatureSigningParameters parameters = signatureParametersResolver.resolveSingle(criteriaSet);
            SignatureSupport.signObject(object, (SignatureSigningParameters)parameters);
        }
        catch (ResolverException | MarshallingException | SecurityException e) {
            throw new SignatureException((Exception)e);
        }
    }

    private SignatureUtils() {
    }
}

