/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class KeyStoreUtils {
    public static List<X509Certificate> getCertificateEntries(KeyStore keyStore) throws KeyStoreException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            certificates.add((X509Certificate)keyStore.getCertificate(alias));
        }
        return certificates;
    }

    public static KeyStore loadSystemTrustStore() throws KeyStoreException {
        String locationProperty = System.getProperty("javax.net.ssl.trustStore");
        if (locationProperty == null) {
            throw new KeyStoreException("System property 'javax.net.ssl.trustStore' was not set - can not load system trust store");
        }
        try {
            return KeyStoreUtils.loadKeyStore(locationProperty, System.getProperty("javax.net.ssl.trustStorePassword"), System.getProperty("javax.net.ssl.trustStoreType"));
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
    }

    public static KeyStore loadKeyStore(String keyStorePath, String keyStorePassword, String keyStoreType) throws KeyStoreException, IOException {
        return KeyStoreUtils.loadKeyStore(new FileInputStream(keyStorePath), keyStorePassword, keyStoreType);
    }

    public static KeyStore loadKeyStore(InputStream keyStoreStream, String keyStorePassword, String keyStoreType) throws KeyStoreException, IOException {
        try {
            KeyStore keyStore = keyStoreType != null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keyStoreStream, keyStorePassword.toCharArray());
            return keyStore;
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException(e);
        }
    }

    private KeyStoreUtils() {
    }
}

