/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider.spring;

import java.io.IOException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang.Validate;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.springframework.core.io.Resource;
import se.litsec.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import se.litsec.opensaml.utils.spring.ResourceProxy;

public class SpringResourceMetadataProvider
extends AbstractMetadataProvider {
    private ResourceBackedMetadataResolver metadataResolver;
    private Resource metadataResource;

    public SpringResourceMetadataProvider(Resource metadataResource) {
        Validate.notNull((Object)metadataResource, (String)"metadataResource must not be null");
        this.metadataResource = metadataResource;
    }

    @Override
    public String getID() {
        return this.metadataResource.getDescription();
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Override
    protected void createMetadataResolver(boolean requireValidMetadata, boolean failFastInitialization, MetadataFilter filter) throws ResolverException {
        try {
            this.metadataResolver = new ResourceBackedMetadataResolver(ResourceProxy.proxy(this.metadataResource));
            this.metadataResolver.setId(this.getID());
            this.metadataResolver.setRequireValidMetadata(requireValidMetadata);
            this.metadataResolver.setFailFastInitialization(failFastInitialization);
            this.metadataResolver.setMetadataFilter(filter);
            this.metadataResolver.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
        }
        catch (IOException e) {
            throw new ResolverException((Exception)e);
        }
    }

    @Override
    protected void initializeMetadataResolver() throws ComponentInitializationException {
        this.metadataResolver.initialize();
    }

    @Override
    protected void destroyMetadataResolver() {
        if (this.metadataResolver != null) {
            this.metadataResolver.destroy();
        }
    }
}

