/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.FileBackedHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.impl.SecurityEnhancedTLSSocketFactory;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.PKIXTrustEvaluator;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.PKIXX509CredentialTrustEngine;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import se.litsec.opensaml.utils.KeyStoreUtils;

public class HTTPMetadataProvider
extends AbstractMetadataProvider {
    private Logger log = LoggerFactory.getLogger(HTTPMetadataProvider.class);
    private HTTPMetadataResolver metadataResolver;
    private HttpClientSecurityParameters tlsSecurityParameters;

    public HTTPMetadataProvider(String metadataUrl, String backupFile) throws ResolverException {
        this(metadataUrl, backupFile, HTTPMetadataProvider.createDefaultHttpClient(), null);
    }

    public HTTPMetadataProvider(String metadataUrl, String backupFile, HttpClientSecurityParameters tlsSecurityParameters) throws ResolverException {
        this(metadataUrl, backupFile, HTTPMetadataProvider.createDefaultHttpClient(), tlsSecurityParameters);
    }

    public HTTPMetadataProvider(String metadataUrl, String backupFile, HttpClient httpClient, HttpClientSecurityParameters tlsSecurityParameters) throws ResolverException {
        Validate.notEmpty((String)metadataUrl, (String)"metadataUrl must be set");
        Validate.notNull((Object)httpClient, (String)"httpClient must not be null");
        Object object = this.metadataResolver = backupFile != null ? new FileBackedHTTPMetadataResolver(httpClient, metadataUrl, backupFile) : new HTTPMetadataResolver(httpClient, metadataUrl);
        if (tlsSecurityParameters == null) {
            this.log.info("Loading TLS trust store from system properties ...");
            try {
                KeyStore trustStore = KeyStoreUtils.loadSystemTrustStore();
                this.tlsSecurityParameters = new HttpClientSecurityParameters();
                this.tlsSecurityParameters.setTLSTrustEngine(HTTPMetadataProvider.createTlsTrustEngine(trustStore));
                this.tlsSecurityParameters.setHostnameVerifier((X509HostnameVerifier)new StrictHostnameVerifier());
            }
            catch (KeyStoreException e) {
                this.log.error("Failed to load system trust store", (Throwable)e);
                throw new ResolverException("Failed to load system trust store", (Exception)e);
            }
        } else {
            this.tlsSecurityParameters = tlsSecurityParameters;
        }
    }

    public static HttpClient createDefaultHttpClient() {
        return HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory((LayeredConnectionSocketFactory)new SecurityEnhancedTLSSocketFactory(HttpClientSupport.buildNoTrustTLSSocketFactory())).build();
    }

    @Override
    public String getID() {
        return this.metadataResolver.getMetadataURI();
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Override
    protected void createMetadataResolver(boolean requireValidMetadata, boolean failFastInitialization, MetadataFilter filter) throws ResolverException {
        this.metadataResolver.setId(this.getID());
        this.metadataResolver.setFailFastInitialization(failFastInitialization);
        this.metadataResolver.setRequireValidMetadata(requireValidMetadata);
        this.metadataResolver.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
        this.metadataResolver.setMetadataFilter(filter);
        this.metadataResolver.setHttpClientSecurityParameters(this.tlsSecurityParameters);
    }

    public static TrustEngine<? super X509Credential> createTlsTrustEngine(KeyStore trustStore) throws KeyStoreException {
        List<X509Certificate> trustedCertificates = KeyStoreUtils.getCertificateEntries(trustStore);
        BasicPKIXValidationInformation info = new BasicPKIXValidationInformation(trustedCertificates, null, null);
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(Collections.singletonList(info), Collections.emptySet());
        return new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)resolver, (PKIXTrustEvaluator)new CertPathPKIXTrustEvaluator(), null);
    }

    @Override
    protected void initializeMetadataResolver() throws ComponentInitializationException {
        this.metadataResolver.initialize();
    }

    @Override
    protected void destroyMetadataResolver() {
        if (this.metadataResolver != null) {
            this.metadataResolver.destroy();
        }
    }
}

