/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.joda.time.DateTime;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.impl.PredicateFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SchemaValidationFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import se.litsec.opensaml.saml2.metadata.provider.MetadataProvider;
import se.litsec.opensaml.utils.ObjectUtils;
import se.litsec.opensaml.utils.PredicateWrapper;

public abstract class AbstractMetadataProvider
extends AbstractInitializableComponent
implements MetadataProvider {
    private Logger log = LoggerFactory.getLogger(AbstractMetadataProvider.class);
    private boolean requireValidMetadata = true;
    private boolean failFastInitialization = false;
    private X509Certificate signatureVerificationCertificate = null;
    private boolean performSchemaValidation = false;
    private List<Predicate<EntityDescriptor>> inclusionPredicates = null;
    private List<Predicate<EntityDescriptor>> exclusionPredicates = null;
    private XMLObject metadata;
    private DateTime downloadTime;

    @Override
    public synchronized Optional<XMLObject> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public Optional<Element> getMetadataDOM() throws MarshallingException {
        Optional<XMLObject> md = this.getMetadata();
        if (!md.isPresent()) {
            return Optional.empty();
        }
        if (md.get().getDOM() != null) {
            return Optional.of(md.get().getDOM());
        }
        return Optional.of(ObjectUtils.marshall(md.get()));
    }

    @Override
    public Optional<DateTime> getLastUpdate() {
        if (RefreshableMetadataResolver.class.isInstance(this.getMetadataResolver())) {
            return Optional.ofNullable(((RefreshableMetadataResolver)this.getMetadataResolver()).getLastUpdate());
        }
        return Optional.ofNullable(this.downloadTime);
    }

    @Override
    public void refresh() throws ResolverException {
        if (RefreshableMetadataResolver.class.isInstance(this.getMetadataResolver())) {
            ((RefreshableMetadataResolver)this.getMetadataResolver()).refresh();
        } else {
            this.log.debug("Refresh of metadata is not supported by {}", (Object)this.getClass().getName());
        }
    }

    @Override
    public Iterable<EntityDescriptor> iterator() {
        return new EntityDescriptorIterator(this.getMetadata());
    }

    @Override
    public Iterable<EntityDescriptor> iterator(QName role) {
        return new EntityDescriptorIterator(this.getMetadata(), role);
    }

    @Override
    public Optional<EntityDescriptor> getEntityDescriptor(String entityID) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EntityIdCriterion(entityID));
        return Optional.ofNullable(this.getMetadataResolver().resolveSingle((Object)criteria));
    }

    @Override
    public Optional<IDPSSODescriptor> getIDPSSODescriptor(String entityID) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EntityIdCriterion(entityID));
        criteria.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        EntityDescriptor ed = (EntityDescriptor)this.getMetadataResolver().resolveSingle((Object)criteria);
        return ed != null ? Optional.ofNullable(ed.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol")) : Optional.empty();
    }

    @Override
    public Optional<SPSSODescriptor> getSPSSODescriptor(String entityID) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EntityIdCriterion(entityID));
        criteria.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        EntityDescriptor ed = (EntityDescriptor)this.getMetadataResolver().resolveSingle((Object)criteria);
        return ed != null ? Optional.ofNullable(ed.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol")) : Optional.empty();
    }

    @Override
    public List<EntityDescriptor> getIdentityProviders() throws ResolverException {
        ArrayList<EntityDescriptor> list = new ArrayList<EntityDescriptor>();
        Iterable<EntityDescriptor> it = this.iterator(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        it.forEach(list::add);
        return list;
    }

    @Override
    public List<EntityDescriptor> getServiceProviders() throws ResolverException {
        ArrayList<EntityDescriptor> list = new ArrayList<EntityDescriptor>();
        Iterable<EntityDescriptor> it = this.iterator(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        it.forEach(list::add);
        return list;
    }

    private synchronized void setMetadata(XMLObject metadata) {
        this.metadata = metadata;
        this.downloadTime = new DateTime();
    }

    protected final void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.createMetadataResolver(this.requireValidMetadata, this.failFastInitialization, this.createFilter());
        }
        catch (ResolverException e) {
            throw new ComponentInitializationException((Exception)((Object)e));
        }
        this.initializeMetadataResolver();
    }

    protected MetadataFilter createFilter() {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.signatureVerificationCertificate != null) {
            StaticCredentialResolver credentialResolver = new StaticCredentialResolver((Credential)new BasicX509Credential(this.signatureVerificationCertificate));
            BasicProviderKeyInfoCredentialResolver basicProviderKeyInfoCredentialResolver = new BasicProviderKeyInfoCredentialResolver(Arrays.asList(new RSAKeyValueProvider(), new InlineX509DataProvider(), new DSAKeyValueProvider(), new DEREncodedKeyValueProvider()));
            ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credentialResolver, (KeyInfoCredentialResolver)basicProviderKeyInfoCredentialResolver);
            filters.add(new SignatureValidationFilter((SignatureTrustEngine)trustEngine));
        }
        if (this.performSchemaValidation) {
            filters.add(new SchemaValidationFilter(new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11)));
        }
        if (this.inclusionPredicates != null) {
            for (Predicate predicate : this.inclusionPredicates) {
                filters.add(new PredicateFilter(PredicateFilter.Direction.INCLUDE, PredicateWrapper.wrap(predicate)));
            }
        }
        if (this.exclusionPredicates != null) {
            for (Predicate predicate : this.exclusionPredicates) {
                filters.add(new PredicateFilter(PredicateFilter.Direction.EXCLUDE, PredicateWrapper.wrap(predicate)));
            }
        }
        filters.add(metadata -> {
            this.setMetadata(metadata);
            return metadata;
        });
        if (filters.size() == 1) {
            return (MetadataFilter)filters.get(0);
        }
        MetadataFilterChain chain = new MetadataFilterChain();
        chain.setFilters(filters);
        return chain;
    }

    protected void doDestroy() {
        super.doDestroy();
        this.destroyMetadataResolver();
    }

    protected abstract void createMetadataResolver(boolean var1, boolean var2, MetadataFilter var3) throws ResolverException;

    protected abstract void initializeMetadataResolver() throws ComponentInitializationException;

    protected abstract void destroyMetadataResolver();

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireValidMetadata = requireValidMetadata;
    }

    public void setFailFastInitialization(boolean failFast) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.failFastInitialization = failFast;
    }

    public void setSignatureVerificationCertificate(X509Certificate signatureVerificationCertificate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signatureVerificationCertificate = signatureVerificationCertificate;
    }

    public void setPerformSchemaValidation(boolean performSchemaValidation) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.performSchemaValidation = performSchemaValidation;
    }

    public void setInclusionPredicates(List<Predicate<EntityDescriptor>> inclusionPredicates) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.inclusionPredicates = inclusionPredicates;
    }

    public void setExclusionPredicates(List<Predicate<EntityDescriptor>> exclusionPredicates) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.exclusionPredicates = exclusionPredicates;
    }

    protected static class EntityDescriptorIterator
    implements Iterator<EntityDescriptor>,
    Iterable<EntityDescriptor> {
        private Iterator<EntityDescriptor> iterator = null;

        public EntityDescriptorIterator(Optional<XMLObject> metadata) {
            this(metadata, null);
        }

        public EntityDescriptorIterator(Optional<XMLObject> metadata, QName role) {
            if (!metadata.isPresent()) {
                return;
            }
            if (metadata.get() instanceof EntityDescriptor) {
                this.iterator = Collections.singletonList((EntityDescriptor)metadata.get()).iterator();
            } else if (metadata.get() instanceof EntitiesDescriptor) {
                List<EntityDescriptor> edList = EntityDescriptorIterator.setup((EntitiesDescriptor)metadata.get(), role);
                this.iterator = edList.iterator();
            } else {
                throw new IllegalArgumentException("Expected EntityDescriptor or EntitiesDescriptor");
            }
        }

        private static List<EntityDescriptor> setup(EntitiesDescriptor entitiesDescriptor, QName role) {
            ArrayList<EntityDescriptor> edList = new ArrayList<EntityDescriptor>();
            entitiesDescriptor.getEntityDescriptors().stream().filter(EntityDescriptorIterator.filterRole(role)).forEach(edList::add);
            for (EntitiesDescriptor ed : entitiesDescriptor.getEntitiesDescriptors()) {
                edList.addAll(EntityDescriptorIterator.setup(ed, role));
            }
            return edList;
        }

        public static Predicate<EntityDescriptor> filterRole(QName role) {
            return e -> role == null || !e.getRoleDescriptors(role).isEmpty();
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public EntityDescriptor next() {
            if (this.iterator != null) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        @Nonnull
        public Iterator<EntityDescriptor> iterator() {
            return this;
        }
    }
}

