/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build.spring;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import se.litsec.opensaml.saml2.metadata.build.KeyDescriptorBuilder;

public class KeyDescriptorListFactoryBean
extends AbstractFactoryBean<List<KeyDescriptor>> {
    private List<X509Certificate> signatureCertificates;
    private List<X509Certificate> encryptionCertificates;
    private List<X509Certificate> unspecifiedCertificates;

    public void setSigningCredential(X509Credential signingCredential) {
        this.signatureCertificates = signingCredential != null ? Collections.singletonList(signingCredential.getEntityCertificate()) : null;
    }

    public void setSigningCertificate(X509Certificate signingCertificate) {
        this.signatureCertificates = signingCertificate != null ? Collections.singletonList(signingCertificate) : null;
    }

    public void setSigningCredentials(List<X509Credential> signingCredentials) {
        this.signatureCertificates = signingCredentials != null ? signingCredentials.stream().map(X509Credential::getEntityCertificate).collect(Collectors.toList()) : null;
    }

    public void setSigningCertificates(List<X509Certificate> signingCertificates) {
        this.signatureCertificates = signingCertificates;
    }

    public void setEncryptionCredential(X509Credential encryptionCredential) {
        this.encryptionCertificates = encryptionCredential != null ? Collections.singletonList(encryptionCredential.getEntityCertificate()) : null;
    }

    public void setEncryptionCertificate(X509Certificate encryptionCertificate) {
        this.encryptionCertificates = encryptionCertificate != null ? Collections.singletonList(encryptionCertificate) : null;
    }

    public void setEncryptionCredentials(List<X509Credential> encryptionCredentials) {
        this.encryptionCertificates = encryptionCredentials != null ? encryptionCredentials.stream().map(X509Credential::getEntityCertificate).collect(Collectors.toList()) : null;
    }

    public void setEncryptionCertificates(List<X509Certificate> encryptionCertificates) {
        this.encryptionCertificates = encryptionCertificates;
    }

    public void setUnspecifiedCredentials(List<X509Credential> credentials) {
        this.unspecifiedCertificates = credentials != null ? credentials.stream().map(X509Credential::getEntityCertificate).collect(Collectors.toList()) : null;
    }

    public void setUnspecifiedCertificates(List<X509Certificate> certificates) {
        this.unspecifiedCertificates = certificates;
    }

    protected List<KeyDescriptor> createInstance() throws Exception {
        ArrayList<KeyDescriptor> keyDescriptors = new ArrayList<KeyDescriptor>();
        if (this.signatureCertificates != null) {
            keyDescriptors.addAll(this.signatureCertificates.stream().map(c -> (KeyDescriptor)KeyDescriptorBuilder.builder().certificate((X509Certificate)c).use(UsageType.SIGNING).build()).collect(Collectors.toList()));
        }
        if (this.encryptionCertificates != null) {
            keyDescriptors.addAll(this.encryptionCertificates.stream().map(c -> (KeyDescriptor)KeyDescriptorBuilder.builder().certificate((X509Certificate)c).use(UsageType.ENCRYPTION).build()).collect(Collectors.toList()));
        }
        if (this.unspecifiedCertificates != null) {
            keyDescriptors.addAll(this.unspecifiedCertificates.stream().map(c -> (KeyDescriptor)KeyDescriptorBuilder.builder().certificate((X509Certificate)c).use(UsageType.UNSPECIFIED).build()).collect(Collectors.toList()));
        }
        return keyDescriptors;
    }

    public Class<?> getObjectType() {
        return List.class;
    }
}

