/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build.spring;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.springframework.core.io.Resource;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.core.spring.AbstractSAMLObjectBuilderFactoryBean;
import se.litsec.opensaml.saml2.metadata.build.KeyDescriptorBuilder;

public class KeyDescriptorFactoryBean
extends AbstractSAMLObjectBuilderFactoryBean<KeyDescriptor> {
    private KeyDescriptorBuilder builder = KeyDescriptorBuilder.builder();

    public void setUse(UsageType usageType) {
        this.builder.use(usageType);
    }

    public void setKeyName(String name) {
        this.builder.keyName(name);
    }

    public void setCertificate(X509Certificate certificate) {
        this.builder.certificate(certificate);
    }

    public void setCertificate(X509Credential credential) {
        this.builder.certificate(credential);
    }

    public void setCertificateResource(Resource certificateResource) throws IOException {
        this.builder.certificate(certificateResource.getInputStream());
    }

    public void setEncryptionMethods(List<String> encryptionMethods) {
        this.builder.encryptionMethods(encryptionMethods);
    }

    public void setEncryptionMethodsExt(List<EncryptionMethod> encryptionMethods) {
        this.builder.encryptionMethodsExt(encryptionMethods);
    }

    @Override
    protected AbstractSAMLObjectBuilder<KeyDescriptor> builder() {
        return this.builder;
    }

    public Class<?> getObjectType() {
        return KeyDescriptor.class;
    }
}

