/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.ext.saml2mdui.Description;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.InformationURL;
import org.opensaml.saml.ext.saml2mdui.Keywords;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.core.LocalizedString;
import se.litsec.opensaml.utils.ObjectUtils;

public class UIInfoBuilder
extends AbstractSAMLObjectBuilder<UIInfo> {
    public static UIInfoBuilder builder() {
        return new UIInfoBuilder();
    }

    @Override
    protected Class<UIInfo> getObjectType() {
        return UIInfo.class;
    }

    public UIInfoBuilder displayNames(List<LocalizedString> displayNames) {
        if (displayNames != null) {
            for (LocalizedString s : displayNames) {
                DisplayName dn = ObjectUtils.createSamlObject(DisplayName.class);
                dn.setValue(s.getLocalString());
                dn.setXMLLang(s.getLanguage());
                ((UIInfo)this.object()).getDisplayNames().add(dn);
            }
        }
        return this;
    }

    public UIInfoBuilder displayNames(LocalizedString ... displayNames) {
        return this.displayNames(displayNames != null ? Arrays.asList(displayNames) : null);
    }

    public UIInfoBuilder keywords(Map<String, List<String>> keywords) {
        if (keywords != null) {
            for (Map.Entry<String, List<String>> e : keywords.entrySet()) {
                Keywords kw = ObjectUtils.createSamlObject(Keywords.class);
                if (!e.getKey().isEmpty()) {
                    kw.setXMLLang(e.getKey());
                }
                kw.setKeywords(e.getValue());
                ((UIInfo)this.object()).getKeywords().add(kw);
            }
        }
        return this;
    }

    public UIInfoBuilder keywords(List<String> keywords) {
        if (keywords != null) {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            m.put("", keywords);
            return this.keywords(m);
        }
        return this;
    }

    public UIInfoBuilder keywords(String ... keywords) {
        return this.keywords(keywords != null ? Arrays.asList(keywords) : null);
    }

    public UIInfoBuilder descriptions(List<LocalizedString> descriptions) {
        if (descriptions != null) {
            for (LocalizedString s : descriptions) {
                Description d = ObjectUtils.createSamlObject(Description.class);
                d.setValue(s.getLocalString());
                d.setXMLLang(s.getLanguage());
                ((UIInfo)this.object()).getDescriptions().add(d);
            }
        }
        return this;
    }

    public UIInfoBuilder descriptions(LocalizedString ... descriptions) {
        return this.descriptions(descriptions != null ? Arrays.asList(descriptions) : null);
    }

    public UIInfoBuilder logos(List<Logo> logos) {
        try {
            if (logos != null) {
                for (Logo logo : logos) {
                    ((UIInfo)this.object()).getLogos().add(XMLObjectSupport.cloneXMLObject((XMLObject)logo));
                }
            }
            return this;
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new RuntimeException(e);
        }
    }

    public UIInfoBuilder logos(Logo ... logos) {
        return this.logos(logos != null ? Arrays.asList(logos) : null);
    }

    public UIInfoBuilder informationURLs(List<LocalizedString> informationURLs) {
        if (informationURLs != null) {
            for (LocalizedString u : informationURLs) {
                InformationURL url = ObjectUtils.createSamlObject(InformationURL.class);
                url.setValue(u.getLocalString());
                url.setXMLLang(u.getLanguage());
                ((UIInfo)this.object()).getInformationURLs().add(url);
            }
        }
        return this;
    }

    public UIInfoBuilder informationURLs(LocalizedString ... informationURLs) {
        return this.informationURLs(informationURLs != null ? Arrays.asList(informationURLs) : null);
    }

    public UIInfoBuilder privacyStatementURLs(List<LocalizedString> privacyStatementURLs) {
        if (privacyStatementURLs != null) {
            for (LocalizedString u : privacyStatementURLs) {
                PrivacyStatementURL url = ObjectUtils.createSamlObject(PrivacyStatementURL.class);
                url.setValue(u.getLocalString());
                url.setXMLLang(u.getLanguage());
                ((UIInfo)this.object()).getPrivacyStatementURLs().add(url);
            }
        }
        return this;
    }

    public UIInfoBuilder privacyStatementURLs(LocalizedString ... privacyStatementURLs) {
        return this.privacyStatementURLs(privacyStatementURLs != null ? Arrays.asList(privacyStatementURLs) : null);
    }
}

