/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.ext.idpdisco.DiscoveryResponse;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;
import se.litsec.opensaml.saml2.metadata.build.AbstractEntityDescriptorBuilder;
import se.litsec.opensaml.utils.ObjectUtils;

public class SpEntityDescriptorBuilder
extends AbstractEntityDescriptorBuilder<SpEntityDescriptorBuilder> {
    public SpEntityDescriptorBuilder() {
    }

    public SpEntityDescriptorBuilder(InputStream resource) throws XMLParserException, UnmarshallingException, IOException {
        super(resource);
    }

    public SpEntityDescriptorBuilder(EntityDescriptor template) throws UnmarshallingException, MarshallingException {
        super(template);
    }

    public static SpEntityDescriptorBuilder builder() {
        return new SpEntityDescriptorBuilder();
    }

    public static SpEntityDescriptorBuilder builder(InputStream resource) throws XMLParserException, UnmarshallingException, IOException {
        return new SpEntityDescriptorBuilder(resource);
    }

    public static SpEntityDescriptorBuilder builder(EntityDescriptor template) throws UnmarshallingException, MarshallingException {
        return new SpEntityDescriptorBuilder(template);
    }

    @Override
    protected SpEntityDescriptorBuilder getThis() {
        return this;
    }

    public SpEntityDescriptorBuilder authnRequestsSigned(Boolean b) {
        ((SPSSODescriptor)this.ssoDescriptor()).setAuthnRequestsSigned(b);
        return this;
    }

    public SpEntityDescriptorBuilder wantAssertionsSigned(Boolean b) {
        ((SPSSODescriptor)this.ssoDescriptor()).setWantAssertionsSigned(b);
        return this;
    }

    public SpEntityDescriptorBuilder discoveryResponses(List<String> locations) {
        if (this.ssoDescriptor().getExtensions() == null) {
            if (locations == null) {
                return this;
            }
            this.ssoDescriptor().setExtensions(ObjectUtils.createSamlObject(Extensions.class));
        } else if (!MetadataUtils.getMetadataExtensions(this.ssoDescriptor().getExtensions(), DiscoveryResponse.class).isEmpty()) {
            List save = this.ssoDescriptor().getExtensions().getOrderedChildren().stream().filter(e -> !DiscoveryResponse.class.isAssignableFrom(e.getClass())).collect(Collectors.toList());
            this.ssoDescriptor().getExtensions().getOrderedChildren().clear();
            this.ssoDescriptor().getExtensions().getOrderedChildren().addAll(save);
        }
        if (locations != null) {
            int index = 1;
            for (String location : locations) {
                DiscoveryResponse discoveryResponse = ObjectUtils.createSamlObject(DiscoveryResponse.class);
                discoveryResponse.setBinding("urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol");
                discoveryResponse.setIndex(Integer.valueOf(index++));
                discoveryResponse.setLocation(location);
                this.ssoDescriptor().getExtensions().getUnknownXMLObjects().add(discoveryResponse);
            }
        }
        return this;
    }

    public SpEntityDescriptorBuilder discoveryResponses(String ... locations) {
        return this.discoveryResponses(locations != null ? Arrays.asList(locations) : null);
    }

    public SpEntityDescriptorBuilder assertionConsumerServices(List<AssertionConsumerService> assertionConsumerServices) {
        SPSSODescriptor spDescriptor = (SPSSODescriptor)this.ssoDescriptor();
        spDescriptor.getAssertionConsumerServices().clear();
        if (assertionConsumerServices == null) {
            return this;
        }
        for (AssertionConsumerService a : assertionConsumerServices) {
            try {
                spDescriptor.getAssertionConsumerServices().add(XMLObjectSupport.cloneXMLObject((XMLObject)a));
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public SpEntityDescriptorBuilder assertionConsumerServices(AssertionConsumerService ... assertionConsumerServices) {
        return this.assertionConsumerServices(assertionConsumerServices != null ? Arrays.asList(assertionConsumerServices) : null);
    }

    public SpEntityDescriptorBuilder attributeConsumingServices(List<AttributeConsumingService> attributeConsumingServices) {
        SPSSODescriptor spDescriptor = (SPSSODescriptor)this.ssoDescriptor();
        spDescriptor.getAttributeConsumingServices().clear();
        if (attributeConsumingServices == null) {
            return null;
        }
        for (AttributeConsumingService a : attributeConsumingServices) {
            try {
                spDescriptor.getAttributeConsumingServices().add(XMLObjectSupport.cloneXMLObject((XMLObject)a));
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public SpEntityDescriptorBuilder attributeConsumingServices(AttributeConsumingService ... attributeConsumingServices) {
        return this.attributeConsumingServices(attributeConsumingServices != null ? Arrays.asList(attributeConsumingServices) : null);
    }

    @Override
    protected SSODescriptor ssoDescriptor() {
        if (((EntityDescriptor)this.object()).getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") == null) {
            SPSSODescriptor d = ObjectUtils.createSamlObject(SPSSODescriptor.class);
            d.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            ((EntityDescriptor)this.object()).getRoleDescriptors().add(d);
        }
        return ((EntityDescriptor)this.object()).getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    @Override
    protected boolean matchingSSODescriptorType(EntityDescriptor descriptor) {
        if (((EntityDescriptor)this.object()).getRoleDescriptors().isEmpty()) {
            return true;
        }
        return ((EntityDescriptor)this.object()).getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") != null;
    }
}

