/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import se.litsec.opensaml.saml2.attribute.AttributeTemplate;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;
import se.litsec.opensaml.saml2.metadata.build.AbstractEntityDescriptorBuilder;
import se.litsec.opensaml.utils.ObjectUtils;

public class IdpEntityDescriptorBuilder
extends AbstractEntityDescriptorBuilder<IdpEntityDescriptorBuilder> {
    public static final String ASSURANCE_CERTIFICATION_ATTRIBUTE_NAME = "urn:oasis:names:tc:SAML:attribute:assurance-certification";
    public static final AttributeTemplate ASSURANCE_CERTIFICATION_ATTRIBUTE_TEMPLATE = new AttributeTemplate("urn:oasis:names:tc:SAML:attribute:assurance-certification", null);

    public IdpEntityDescriptorBuilder() {
    }

    public IdpEntityDescriptorBuilder(InputStream resource) throws XMLParserException, UnmarshallingException, IOException {
        super(resource);
    }

    public IdpEntityDescriptorBuilder(EntityDescriptor template) throws UnmarshallingException, MarshallingException {
        super(template);
    }

    public static IdpEntityDescriptorBuilder builder() {
        return new IdpEntityDescriptorBuilder();
    }

    public static IdpEntityDescriptorBuilder builder(InputStream resource) throws XMLParserException, UnmarshallingException, IOException {
        return new IdpEntityDescriptorBuilder(resource);
    }

    public static IdpEntityDescriptorBuilder builder(EntityDescriptor template) throws UnmarshallingException, MarshallingException {
        return new IdpEntityDescriptorBuilder(template);
    }

    @Override
    protected IdpEntityDescriptorBuilder getThis() {
        return this;
    }

    @Override
    protected SSODescriptor ssoDescriptor() {
        if (((EntityDescriptor)this.object()).getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") == null) {
            IDPSSODescriptor d = ObjectUtils.createSamlObject(IDPSSODescriptor.class);
            d.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            ((EntityDescriptor)this.object()).getRoleDescriptors().add(d);
        }
        return ((EntityDescriptor)this.object()).getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    @Override
    protected boolean matchingSSODescriptorType(EntityDescriptor descriptor) {
        if (((EntityDescriptor)this.object()).getRoleDescriptors().isEmpty()) {
            return true;
        }
        return ((EntityDescriptor)this.object()).getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") != null;
    }

    public IdpEntityDescriptorBuilder wantAuthnRequestsSigned(Boolean b) {
        ((IDPSSODescriptor)this.ssoDescriptor()).setWantAuthnRequestsSigned(b);
        return this;
    }

    public IdpEntityDescriptorBuilder assuranceCertificationUris(List<String> uris) {
        Optional<EntityAttributes> entityAttributes = MetadataUtils.getEntityAttributes((EntityDescriptor)this.object());
        if (!entityAttributes.isPresent()) {
            if (uris == null || uris.isEmpty()) {
                return this;
            }
            return (IdpEntityDescriptorBuilder)this.entityAttributesExtension(Collections.singletonList(ASSURANCE_CERTIFICATION_ATTRIBUTE_TEMPLATE.createBuilder().value(uris).build()));
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        entityAttributes.get().getAttributes().stream().filter(a -> !ASSURANCE_CERTIFICATION_ATTRIBUTE_NAME.equals(a.getName())).forEach(attributeList::add);
        if (uris != null) {
            attributeList.add(ASSURANCE_CERTIFICATION_ATTRIBUTE_TEMPLATE.createBuilder().value(uris).build());
        }
        return (IdpEntityDescriptorBuilder)this.entityAttributesExtension(attributeList);
    }

    public IdpEntityDescriptorBuilder assuranceCertificationUris(String ... uris) {
        return this.assuranceCertificationUris(uris != null ? Arrays.asList(uris) : null);
    }

    public IdpEntityDescriptorBuilder singleSignOnServices(List<SingleSignOnService> singleSignOnServices) {
        IDPSSODescriptor idpDescriptor = (IDPSSODescriptor)this.ssoDescriptor();
        idpDescriptor.getSingleSignOnServices().clear();
        if (singleSignOnServices == null) {
            return this;
        }
        for (SingleSignOnService sso : singleSignOnServices) {
            try {
                idpDescriptor.getSingleSignOnServices().add(XMLObjectSupport.cloneXMLObject((XMLObject)sso));
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public IdpEntityDescriptorBuilder singleSignOnServices(SingleSignOnService ... singleSignOnServices) {
        return this.singleSignOnServices(singleSignOnServices != null ? Arrays.asList(singleSignOnServices) : null);
    }
}

