/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.xmlsec.encryption.KeySize;
import org.opensaml.xmlsec.encryption.OAEPparams;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.utils.ObjectUtils;

public class EncryptionMethodBuilder
extends AbstractSAMLObjectBuilder<EncryptionMethod> {
    public static EncryptionMethodBuilder builder() {
        return new EncryptionMethodBuilder();
    }

    public static EncryptionMethod encryptionMethod(String algorithm) {
        return (EncryptionMethod)EncryptionMethodBuilder.builder().algorithm(algorithm).build();
    }

    public static EncryptionMethod encryptionMethod(String algorithm, Integer keySize) {
        return (EncryptionMethod)EncryptionMethodBuilder.builder().algorithm(algorithm).keySize(keySize).build();
    }

    @Override
    protected Class<EncryptionMethod> getObjectType() {
        return EncryptionMethod.class;
    }

    public EncryptionMethodBuilder algorithm(String algorithm) {
        ((EncryptionMethod)this.object()).setAlgorithm(algorithm);
        return this;
    }

    public EncryptionMethodBuilder keySize(Integer keySize) {
        KeySize size = ObjectUtils.createXMLObject(KeySize.class, KeySize.DEFAULT_ELEMENT_NAME);
        ((EncryptionMethod)this.object()).setKeySize(size);
        return this;
    }

    public EncryptionMethodBuilder oAEPparams(String base64Encoding) {
        OAEPparams p = ObjectUtils.createXMLObject(OAEPparams.class, OAEPparams.DEFAULT_ELEMENT_NAME);
        ((EncryptionMethod)this.object()).setOAEPparams(p);
        return this;
    }
}

