/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import java.util.Arrays;
import java.util.List;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.utils.ObjectUtils;

public class ContactPersonBuilder
extends AbstractSAMLObjectBuilder<ContactPerson> {
    public ContactPersonBuilder() {
    }

    public ContactPersonBuilder(ContactPerson template) throws MarshallingException, UnmarshallingException {
        super(template);
    }

    public static ContactPersonBuilder builder() {
        return new ContactPersonBuilder();
    }

    public static ContactPersonBuilder builder(ContactPerson template) throws MarshallingException, UnmarshallingException {
        return new ContactPersonBuilder(template);
    }

    public ContactPersonBuilder type(ContactPersonTypeEnumeration type) {
        ((ContactPerson)this.object()).setType(type);
        return this;
    }

    public ContactPersonBuilder company(String company) {
        if (company != null) {
            Company c = ObjectUtils.createSamlObject(Company.class);
            c.setName(company);
            ((ContactPerson)this.object()).setCompany(c);
        }
        return this;
    }

    public ContactPersonBuilder givenName(String givenName) {
        if (givenName != null) {
            GivenName gn = ObjectUtils.createSamlObject(GivenName.class);
            gn.setName(givenName);
            ((ContactPerson)this.object()).setGivenName(gn);
        }
        return this;
    }

    public ContactPersonBuilder surname(String surname) {
        if (surname != null) {
            SurName sn = ObjectUtils.createSamlObject(SurName.class);
            sn.setName(surname);
            ((ContactPerson)this.object()).setSurName(sn);
        }
        return this;
    }

    public ContactPersonBuilder emailAddresses(List<String> emailAddresses) {
        if (emailAddresses != null) {
            for (String e : emailAddresses) {
                EmailAddress ea = ObjectUtils.createSamlObject(EmailAddress.class);
                ea.setAddress(e);
                ((ContactPerson)this.object()).getEmailAddresses().add(ea);
            }
        }
        return this;
    }

    public ContactPersonBuilder emailAddresses(String ... emailAddresses) {
        return this.emailAddresses(emailAddresses != null ? Arrays.asList(emailAddresses) : null);
    }

    public ContactPersonBuilder telephoneNumbers(List<String> telephoneNumbers) {
        if (telephoneNumbers != null) {
            for (String t : telephoneNumbers) {
                TelephoneNumber tn = ObjectUtils.createSamlObject(TelephoneNumber.class);
                tn.setNumber(t);
                ((ContactPerson)this.object()).getTelephoneNumbers().add(tn);
            }
        }
        return this;
    }

    public ContactPersonBuilder telephoneNumbers(String ... telephoneNumbers) {
        return this.telephoneNumbers(telephoneNumbers != null ? Arrays.asList(telephoneNumbers) : null);
    }

    @Override
    protected Class<ContactPerson> getObjectType() {
        return ContactPerson.class;
    }
}

