/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.saml2.attribute.AttributeTemplate;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;
import se.litsec.opensaml.utils.ObjectUtils;

public abstract class AbstractEntityDescriptorBuilder<T extends AbstractSAMLObjectBuilder<EntityDescriptor>>
extends AbstractSAMLObjectBuilder<EntityDescriptor> {
    public static final String ENTITY_CATEGORY_ATTRIBUTE_NAME = "http://macedir.org/entity-category";
    public static final AttributeTemplate ENTITY_CATEGORY_TEMPLATE = new AttributeTemplate("http://macedir.org/entity-category", null);

    public AbstractEntityDescriptorBuilder() {
    }

    public AbstractEntityDescriptorBuilder(InputStream resource) throws XMLParserException, UnmarshallingException, IOException {
        super(resource);
        if (!this.matchingSSODescriptorType((EntityDescriptor)this.object())) {
            throw new IllegalArgumentException("The SSO descriptor of the template does not match the builder type");
        }
        ((EntityDescriptor)this.object()).setSignature(null);
    }

    public AbstractEntityDescriptorBuilder(EntityDescriptor template) throws UnmarshallingException, MarshallingException {
        super(template);
        if (!this.matchingSSODescriptorType((EntityDescriptor)this.object())) {
            throw new IllegalArgumentException("The SSO descriptor of the template does not match the builder type");
        }
        ((EntityDescriptor)this.object()).setSignature(null);
    }

    @Override
    protected Class<EntityDescriptor> getObjectType() {
        return EntityDescriptor.class;
    }

    protected abstract T getThis();

    protected abstract SSODescriptor ssoDescriptor();

    protected abstract boolean matchingSSODescriptorType(EntityDescriptor var1);

    public T entityID(String entityID) {
        ((EntityDescriptor)this.object()).setEntityID(entityID);
        return this.getThis();
    }

    public T id(String id) {
        ((EntityDescriptor)this.object()).setID(id);
        return this.getThis();
    }

    public T cacheDuration(Long cacheDuration) {
        ((EntityDescriptor)this.object()).setCacheDuration(cacheDuration);
        return this.getThis();
    }

    public T validUntil(DateTime time) {
        ((EntityDescriptor)this.object()).setValidUntil(time);
        return this.getThis();
    }

    public T validUntil(LocalDateTime time) {
        if (time == null) {
            ((EntityDescriptor)this.object()).setValidUntil(null);
        } else {
            ((EntityDescriptor)this.object()).setValidUntil(new DateTime(time.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        }
        return this.getThis();
    }

    public T entityAttributesExtension(List<Attribute> attributes) {
        Optional<EntityAttributes> entityAttributes;
        if (((EntityDescriptor)this.object()).getExtensions() == null) {
            if (attributes == null || attributes.isEmpty()) {
                return this.getThis();
            }
            ((EntityDescriptor)this.object()).setExtensions(ObjectUtils.createSamlObject(Extensions.class));
        }
        if (!(entityAttributes = MetadataUtils.getEntityAttributes((EntityDescriptor)this.object())).isPresent()) {
            if (attributes == null || attributes.isEmpty()) {
                return this.getThis();
            }
            entityAttributes = Optional.of(ObjectUtils.createSamlObject(EntityAttributes.class));
            ((EntityDescriptor)this.object()).getExtensions().getUnknownXMLObjects().add(entityAttributes.get());
        }
        entityAttributes.get().getAttributes().clear();
        for (Attribute a : attributes) {
            try {
                entityAttributes.get().getAttributes().add(XMLObjectSupport.cloneXMLObject((XMLObject)a));
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getThis();
    }

    public T entityAttributesExtension(Attribute ... attributes) {
        return this.entityAttributesExtension(attributes != null ? Arrays.asList(attributes) : null);
    }

    public T entityCategories(List<String> entityCategories) {
        Optional<EntityAttributes> entityAttributes = MetadataUtils.getEntityAttributes((EntityDescriptor)this.object());
        if (!entityAttributes.isPresent()) {
            if (entityCategories == null || entityCategories.isEmpty()) {
                return this.getThis();
            }
            return this.entityAttributesExtension(Collections.singletonList(ENTITY_CATEGORY_TEMPLATE.createBuilder().value(entityCategories).build()));
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        entityAttributes.get().getAttributes().stream().filter(a -> !ENTITY_CATEGORY_ATTRIBUTE_NAME.equals(a.getName())).forEach(attributeList::add);
        if (entityCategories != null) {
            attributeList.add(ENTITY_CATEGORY_TEMPLATE.createBuilder().value(entityCategories).build());
        }
        return this.entityAttributesExtension(attributeList);
    }

    public T entityCategories(String ... entityCategories) {
        return this.entityCategories(entityCategories != null ? Arrays.asList(entityCategories) : null);
    }

    public T uiInfoExtension(UIInfo uiInfo) {
        SSODescriptor ssoDescriptor = this.ssoDescriptor();
        if (ssoDescriptor.getExtensions() == null) {
            if (uiInfo == null) {
                return this.getThis();
            }
            ssoDescriptor.setExtensions(ObjectUtils.createSamlObject(Extensions.class));
        }
        this.updateExtensions(ssoDescriptor.getExtensions(), uiInfo != null ? Arrays.asList(uiInfo) : null, UIInfo.DEFAULT_ELEMENT_NAME);
        if (ssoDescriptor.getExtensions().getUnknownXMLObjects().isEmpty()) {
            ssoDescriptor.setExtensions(null);
        }
        return this.getThis();
    }

    public T keyDescriptors(List<KeyDescriptor> keyDescriptors) {
        SSODescriptor ssoDescriptor = this.ssoDescriptor();
        if (ssoDescriptor.getKeyDescriptors().isEmpty() && (keyDescriptors == null || keyDescriptors.isEmpty())) {
            return this.getThis();
        }
        ssoDescriptor.getKeyDescriptors().clear();
        for (KeyDescriptor kd : keyDescriptors) {
            ssoDescriptor.getKeyDescriptors().add(kd);
        }
        return this.getThis();
    }

    public T keyDescriptors(KeyDescriptor ... keyDescriptors) {
        return this.keyDescriptors(keyDescriptors != null ? Arrays.asList(keyDescriptors) : null);
    }

    public T signingMethods(boolean addToRole, List<SigningMethod> signingMethods) {
        Extensions extensions = null;
        extensions = addToRole ? this.ssoDescriptor().getExtensions() : ((EntityDescriptor)this.object()).getExtensions();
        if (extensions == null) {
            if (signingMethods == null || signingMethods.isEmpty()) {
                return this.getThis();
            }
            extensions = ObjectUtils.createSamlObject(Extensions.class);
            if (addToRole) {
                this.ssoDescriptor().setExtensions(extensions);
            } else {
                ((EntityDescriptor)this.object()).setExtensions(extensions);
            }
        }
        this.updateExtensions(extensions, signingMethods, SigningMethod.DEFAULT_ELEMENT_NAME);
        if (extensions.getUnknownXMLObjects().isEmpty()) {
            if (addToRole) {
                this.ssoDescriptor().setExtensions(null);
            } else {
                ((EntityDescriptor)this.object()).setExtensions(null);
            }
        }
        return this.getThis();
    }

    public T signingMethods(boolean addToRole, SigningMethod ... signingMethods) {
        return this.signingMethods(addToRole, signingMethods != null ? Arrays.asList(signingMethods) : null);
    }

    public T digestMethods(boolean addToRole, List<DigestMethod> digestMethods) {
        Extensions extensions = null;
        extensions = addToRole ? this.ssoDescriptor().getExtensions() : ((EntityDescriptor)this.object()).getExtensions();
        if (extensions == null) {
            if (digestMethods == null || digestMethods.isEmpty()) {
                return this.getThis();
            }
            extensions = ObjectUtils.createSamlObject(Extensions.class);
            if (addToRole) {
                this.ssoDescriptor().setExtensions(extensions);
            } else {
                ((EntityDescriptor)this.object()).setExtensions(extensions);
            }
        }
        this.updateExtensions(extensions, digestMethods, DigestMethod.DEFAULT_ELEMENT_NAME);
        if (extensions.getUnknownXMLObjects().isEmpty()) {
            if (addToRole) {
                this.ssoDescriptor().setExtensions(null);
            } else {
                ((EntityDescriptor)this.object()).setExtensions(null);
            }
        }
        return this.getThis();
    }

    public T digestMethods(boolean addToRole, DigestMethod ... digestMethods) {
        return this.digestMethods(addToRole, digestMethods != null ? Arrays.asList(digestMethods) : null);
    }

    public T nameIDFormats(List<String> nameIDFormats) {
        SSODescriptor ssoDescriptor = this.ssoDescriptor();
        ssoDescriptor.getNameIDFormats().clear();
        if (nameIDFormats == null) {
            return this.getThis();
        }
        for (String id : nameIDFormats) {
            NameIDFormat name = ObjectUtils.createSamlObject(NameIDFormat.class);
            name.setFormat(id);
            ssoDescriptor.getNameIDFormats().add(name);
        }
        return this.getThis();
    }

    public T nameIDFormats(String ... nameIDFormats) {
        return this.nameIDFormats(nameIDFormats != null ? Arrays.asList(nameIDFormats) : null);
    }

    public T singleLogoutServices(List<SingleLogoutService> singleLogoutServices) {
        SSODescriptor ssoDescriptor = this.ssoDescriptor();
        ssoDescriptor.getSingleLogoutServices().clear();
        if (singleLogoutServices == null) {
            return this.getThis();
        }
        for (SingleLogoutService slo : singleLogoutServices) {
            try {
                ssoDescriptor.getSingleLogoutServices().add(XMLObjectSupport.cloneXMLObject((XMLObject)slo));
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getThis();
    }

    public T singleLogoutServices(SingleLogoutService ... singleLogoutServices) {
        return this.singleLogoutServices(singleLogoutServices != null ? Arrays.asList(singleLogoutServices) : null);
    }

    public T organization(Organization organization) {
        try {
            ((EntityDescriptor)this.object()).setOrganization((Organization)XMLObjectSupport.cloneXMLObject((XMLObject)organization));
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new RuntimeException(e);
        }
        return this.getThis();
    }

    public T contactPersons(List<ContactPerson> contactPersons) {
        ((EntityDescriptor)this.object()).getContactPersons().clear();
        if (contactPersons != null) {
            for (ContactPerson cp : contactPersons) {
                try {
                    ((EntityDescriptor)this.object()).getContactPersons().add(XMLObjectSupport.cloneXMLObject((XMLObject)cp));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.getThis();
    }

    public T contactPersons(ContactPerson ... contactPersons) {
        return this.contactPersons(contactPersons != null ? Arrays.asList(contactPersons) : null);
    }

    protected <E extends XMLObject> void updateExtensions(Extensions extensions, List<E> elements, QName elementName) {
        List previousContent = extensions.getUnknownXMLObjects(elementName);
        for (XMLObject p : previousContent) {
            extensions.getUnknownXMLObjects().remove(p);
        }
        if (elements == null || elements.isEmpty()) {
            return;
        }
        for (XMLObject elm : elements) {
            try {
                extensions.getUnknownXMLObjects().add(XMLObjectSupport.cloneXMLObject((XMLObject)elm));
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

