/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.core.build;

import java.util.Arrays;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.GetComplete;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.core.SAMLObjectBuilderRuntimeException;
import se.litsec.opensaml.utils.ObjectUtils;

public class ScopingBuilder
extends AbstractSAMLObjectBuilder<Scoping> {
    public static ScopingBuilder builder() {
        return new ScopingBuilder();
    }

    public ScopingBuilder proxyCount(Integer count) {
        ((Scoping)this.object()).setProxyCount(count);
        return this;
    }

    public ScopingBuilder idpList(String completeUri, List<IDPEntry> idpEntries) {
        if (completeUri == null && (idpEntries == null || idpEntries.isEmpty())) {
            ((Scoping)this.object()).setIDPList(null);
        } else {
            IDPList idpList = ObjectUtils.createSamlObject(IDPList.class);
            if (completeUri != null) {
                GetComplete getComplete = ObjectUtils.createSamlObject(GetComplete.class);
                getComplete.setGetComplete(completeUri);
                idpList.setGetComplete(getComplete);
            }
            if (idpEntries != null) {
                for (IDPEntry e : idpEntries) {
                    try {
                        idpList.getIDPEntrys().add(XMLObjectSupport.cloneXMLObject((XMLObject)e));
                    }
                    catch (MarshallingException | UnmarshallingException e1) {
                        throw new SAMLObjectBuilderRuntimeException(e1);
                    }
                }
            }
            ((Scoping)this.object()).setIDPList(idpList);
        }
        return this;
    }

    public ScopingBuilder idpList(String completeUri, IDPEntry ... idpEntries) {
        return this.idpList(completeUri, idpEntries != null ? Arrays.asList(idpEntries) : null);
    }

    public static IDPEntry idpEntry(String providerID, String name, String loc) {
        IDPEntry entry = ObjectUtils.createSamlObject(IDPEntry.class);
        entry.setProviderID(providerID);
        entry.setName(name);
        entry.setLoc(loc);
        return entry;
    }

    public ScopingBuilder requesterIDs(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            ((Scoping)this.object()).getRequesterIDs().clear();
        } else {
            for (String id : ids) {
                RequesterID ri = ObjectUtils.createSamlObject(RequesterID.class);
                ri.setRequesterID(id);
                ((Scoping)this.object()).getRequesterIDs().add(ri);
            }
        }
        return this;
    }

    public ScopingBuilder requesterIDs(String ... ids) {
        return this.requesterIDs(ids != null ? Arrays.asList(ids) : null);
    }

    @Override
    protected Class<Scoping> getObjectType() {
        return Scoping.class;
    }
}

