/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.core.build;

import java.time.LocalDateTime;
import java.time.ZoneId;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.utils.ObjectUtils;

public abstract class AbstractRequestBuilder<T extends RequestAbstractType, BUILDER extends AbstractSAMLObjectBuilder<T>>
extends AbstractSAMLObjectBuilder<T> {
    @Override
    public T build() {
        if (((RequestAbstractType)this.object()).getVersion() == null) {
            ((RequestAbstractType)this.object()).setVersion(SAMLVersion.VERSION_20);
        }
        return (T)((RequestAbstractType)super.build());
    }

    public BUILDER version(int major, int minor) {
        ((RequestAbstractType)this.object()).setVersion(SAMLVersion.valueOf((int)major, (int)minor));
        return this.getThis();
    }

    public BUILDER version(String version) {
        ((RequestAbstractType)this.object()).setVersion(SAMLVersion.valueOf((String)version));
        return this.getThis();
    }

    public BUILDER id(String id) {
        ((RequestAbstractType)this.object()).setID(id);
        return this.getThis();
    }

    public BUILDER issueInstant(DateTime instant) {
        ((RequestAbstractType)this.object()).setIssueInstant(instant);
        return this.getThis();
    }

    public BUILDER issueInstant(LocalDateTime instant) {
        if (instant == null) {
            ((RequestAbstractType)this.object()).setIssueInstant(null);
        } else {
            ((RequestAbstractType)this.object()).setIssueInstant(new DateTime(instant.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        }
        return this.getThis();
    }

    public BUILDER destination(String destination) {
        ((RequestAbstractType)this.object()).setDestination(destination);
        return this.getThis();
    }

    public BUILDER consent(String consent) {
        ((RequestAbstractType)this.object()).setConsent(consent);
        return this.getThis();
    }

    public BUILDER issuer(String issuer) {
        Issuer issuerElement = ObjectUtils.createSamlObject(Issuer.class);
        issuerElement.setValue(issuer);
        issuerElement.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        ((RequestAbstractType)this.object()).setIssuer(issuerElement);
        return this.getThis();
    }

    public BUILDER issuer(Issuer issuer) {
        try {
            ((RequestAbstractType)this.object()).setIssuer((Issuer)XMLObjectSupport.cloneXMLObject((XMLObject)issuer));
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new RuntimeException(e);
        }
        return this.getThis();
    }

    public BUILDER extensions(Extensions extensions) {
        ((RequestAbstractType)this.object()).setExtensions(extensions);
        return this.getThis();
    }

    protected abstract BUILDER getThis();
}

