/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import se.litsec.opensaml.common.validation.AbstractSignableObjectValidator;
import se.litsec.opensaml.common.validation.ValidationSupport;

public class ResponseValidator
extends AbstractSignableObjectValidator<Response> {
    private final Logger log = LoggerFactory.getLogger(ResponseValidator.class);

    public ResponseValidator(SignatureTrustEngine trustEngine, SignaturePrevalidator signaturePrevalidator) {
        super(trustEngine, signaturePrevalidator);
    }

    @Override
    public ValidationResult validate(Response response, ValidationContext context) {
        try {
            ValidationSupport.check(this.validateID(response, context));
            ValidationSupport.check(this.validateVersion(response, context));
            ValidationSupport.check(this.validateStatus(response, context));
            ValidationSupport.check(this.validateIssueInstant(response, context));
            ValidationSupport.check(this.validateInResponseTo(response, context));
            ValidationSupport.check(this.validateDestination(response, context));
            ValidationSupport.check(this.validateConsent(response, context));
            ValidationSupport.check(this.validateIssuer(response, context));
            ValidationSupport.check(this.validateSignature(response, context));
            ValidationSupport.check(this.validateAssertions(response, context));
            ValidationSupport.check(this.validateExtensions(response, context));
        }
        catch (ValidationSupport.ValidationResultException e) {
            return e.getResult();
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateID(Response response, ValidationContext context) {
        if (!StringUtils.hasText((String)response.getID())) {
            context.setValidationFailureMessage("Missing ID attribute in Response");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateVersion(Response response, ValidationContext context) {
        if (response.getVersion() == null || !response.getVersion().toString().equals(SAMLVersion.VERSION_20.toString())) {
            context.setValidationFailureMessage("Invalid SAML version in Response");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateStatus(Response response, ValidationContext context) {
        if (response.getStatus() == null || response.getStatus().getStatusCode() == null || response.getStatus().getStatusCode().getValue() == null) {
            context.setValidationFailureMessage("Missing Status/StatusCode in Response");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateIssueInstant(Response response, ValidationContext context) {
        long allowedClockSkew;
        long maxAgeResponse;
        long issueInstant;
        if (response.getIssueInstant() == null) {
            context.setValidationFailureMessage("Missing IssueInstant attribute in Response");
            return ValidationResult.INVALID;
        }
        long receiveInstant = ResponseValidator.getReceiveInstant(context);
        if (receiveInstant - (issueInstant = response.getIssueInstant().getMillis()) > (maxAgeResponse = ResponseValidator.getMaxAgeReceivedMessage(context)) + (allowedClockSkew = ResponseValidator.getAllowedClockSkew(context))) {
            String msg = String.format("Received Response message is too old - issue-instant: %s - receive-time: %s", response.getIssueInstant(), new DateTime(receiveInstant, (Chronology)ISOChronology.getInstanceUTC()));
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        if (issueInstant - receiveInstant > allowedClockSkew) {
            String msg = String.format("Issue-instant of Response message (%s) is newer than receive time (%s) - Non accepted clock skew", response.getIssueInstant(), new DateTime(receiveInstant, (Chronology)ISOChronology.getInstanceUTC()));
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateInResponseTo(Response response, ValidationContext context) {
        AuthnRequest authnRequest;
        if (response.getInResponseTo() == null) {
            context.setValidationFailureMessage("Missing InResponseTo attribute in Response");
            return ValidationResult.INVALID;
        }
        String expectedInResponseTo = (String)context.getStaticParameters().get("saml2.AuthnRequestID");
        if (expectedInResponseTo == null && (authnRequest = (AuthnRequest)context.getStaticParameters().get("saml2.AuthnRequest")) != null) {
            expectedInResponseTo = authnRequest.getID();
        }
        if (expectedInResponseTo != null) {
            if (!response.getInResponseTo().equals(expectedInResponseTo)) {
                String msg = String.format("Expected Response message for AuthnRequest with ID '%s', but this Response is for '%s'", expectedInResponseTo, response.getInResponseTo());
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        } else {
            context.setValidationFailureMessage("Could not validate InResponseTo of Response (no AuthnRequest ID available)");
            return ValidationResult.INDETERMINATE;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateDestination(Response response, ValidationContext context) {
        if (response.getDestination() == null) {
            context.setValidationFailureMessage("Missing Destination attribute in Response");
            return ValidationResult.INVALID;
        }
        String receiveUrl = (String)context.getStaticParameters().get("saml2.ReceiveURL");
        if (receiveUrl != null) {
            if (!response.getDestination().equals(receiveUrl)) {
                String msg = String.format("Destination attribute (%s) of Response does not match URL on which response was received (%s)", response.getDestination(), receiveUrl);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        } else {
            context.setValidationFailureMessage("Could not validate Destination of Response (no receive URL available)");
            return ValidationResult.INDETERMINATE;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateConsent(Response response, ValidationContext context) {
        return ValidationResult.VALID;
    }

    protected ValidationResult validateIssuer(Response response, ValidationContext context) {
        if (response.getIssuer() == null || response.getIssuer().getValue() == null) {
            context.setValidationFailureMessage("Missing Issuer element in Response");
            return ValidationResult.INVALID;
        }
        String expectedIssuer = (String)context.getStaticParameters().get("saml2.ExpectedIssuer");
        if (expectedIssuer != null) {
            if (!response.getIssuer().getValue().equals(expectedIssuer)) {
                String msg = String.format("Issuer of Response (%s) did not match expected issuer (%s)", response.getIssuer().getValue(), expectedIssuer);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        } else {
            this.log.warn("EXPECTED_ISSUER key not set - will not check issuer of Response");
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateAssertions(Response response, ValidationContext context) {
        if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            if (response.getAssertions().isEmpty() && response.getEncryptedAssertions().isEmpty()) {
                context.setValidationFailureMessage("Response message has success status but does not contain any assertions - invalid");
                return ValidationResult.INVALID;
            }
        } else if (response.getAssertions().size() > 0 || response.getEncryptedAssertions().size() > 0) {
            context.setValidationFailureMessage("Response message has failure status but contains assertions - invalid");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateExtensions(Response response, ValidationContext context) {
        return ValidationResult.VALID;
    }

    @Override
    protected String getIssuer(Response signableObject) {
        return signableObject.getIssuer() != null ? signableObject.getIssuer().getValue() : null;
    }

    @Override
    protected String getID(Response signableObject) {
        return signableObject.getID();
    }

    @Override
    protected String getObjectName() {
        return "Response";
    }
}

