/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import org.opensaml.saml.saml2.core.Status;

public class ResponseStatusErrorException
extends Exception {
    private static final long serialVersionUID = -8050896611037764108L;
    private Status status;
    private String responseId;

    public ResponseStatusErrorException(Status status, String responseId) {
        super(ResponseStatusErrorException.statusToString(status));
        this.status = status;
        this.responseId = responseId;
        if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(status.getStatusCode().getValue())) {
            throw new IllegalArgumentException("Status is success - can not throw ResponseStatusErrorException");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public String getResponseId() {
        return this.responseId;
    }

    public static String statusToString(Status status) {
        StringBuffer sb = new StringBuffer("Status: ");
        sb.append(status.getStatusCode().getValue());
        if (status.getStatusCode().getStatusCode() != null) {
            sb.append(", ").append(status.getStatusCode().getStatusCode().getValue());
        }
        if (status.getStatusMessage() != null && status.getStatusMessage().getMessage() != null) {
            sb.append(" - ").append(status.getStatusMessage().getMessage());
        }
        return sb.toString();
    }
}

