/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import java.io.ByteArrayInputStream;
import java.util.Optional;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.EncryptedElementType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import se.litsec.opensaml.saml2.common.assertion.AssertionValidationParametersBuilder;
import se.litsec.opensaml.saml2.common.assertion.AssertionValidator;
import se.litsec.opensaml.saml2.common.response.MessageReplayChecker;
import se.litsec.opensaml.saml2.common.response.MessageReplayException;
import se.litsec.opensaml.saml2.common.response.ResponseProcessingException;
import se.litsec.opensaml.saml2.common.response.ResponseProcessingInput;
import se.litsec.opensaml.saml2.common.response.ResponseProcessingResult;
import se.litsec.opensaml.saml2.common.response.ResponseProcessingResultImpl;
import se.litsec.opensaml.saml2.common.response.ResponseProcessor;
import se.litsec.opensaml.saml2.common.response.ResponseStatusErrorException;
import se.litsec.opensaml.saml2.common.response.ResponseValidationException;
import se.litsec.opensaml.saml2.common.response.ResponseValidationParametersBuilder;
import se.litsec.opensaml.saml2.common.response.ResponseValidationSettings;
import se.litsec.opensaml.saml2.common.response.ResponseValidator;
import se.litsec.opensaml.saml2.metadata.PeerMetadataResolver;
import se.litsec.opensaml.utils.ObjectUtils;
import se.litsec.opensaml.xmlsec.SAMLObjectDecrypter;

public class ResponseProcessorImpl
implements ResponseProcessor {
    private final Logger log = LoggerFactory.getLogger(ResponseProcessorImpl.class);
    protected SAMLObjectDecrypter decrypter;
    protected MessageReplayChecker messageReplayChecker;
    protected MetadataCredentialResolver metadataCredentialResolver;
    protected SignatureTrustEngine signatureTrustEngine;
    protected SignaturePrevalidator signatureProfileValidator = new SAMLSignatureProfileValidator();
    protected ResponseValidator responseValidator;
    protected AssertionValidator assertionValidator;
    protected ResponseValidationSettings responseValidationSettings;
    private boolean isInitialized = false;

    @Override
    public ResponseProcessingResult processSamlResponse(String samlResponse, String relayState, ResponseProcessingInput input, PeerMetadataResolver peerMetadataResolver, ValidationContext validationContext) throws ResponseStatusErrorException, ResponseProcessingException {
        try {
            Response response = this.decodeResponse(samlResponse);
            if (this.log.isTraceEnabled()) {
                this.log.trace("[{}] Decoded Response: {}", (Object)ResponseProcessorImpl.logId(response), (Object)ObjectUtils.toStringSafe(response));
            }
            String issuer = response.getIssuer() != null ? response.getIssuer().getValue() : null;
            EntityDescriptor idpMetadata = issuer != null ? peerMetadataResolver.getMetadata(issuer) : null;
            this.validateResponse(response, relayState, input, idpMetadata, validationContext);
            this.messageReplayChecker.checkReplay((SAMLObject)response);
            if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
                this.log.info("Authentication failed with status '{}' [{}]", (Object)ResponseStatusErrorException.statusToString(response.getStatus()), (Object)ResponseProcessorImpl.logId(response));
                throw new ResponseStatusErrorException(response.getStatus(), response.getID());
            }
            this.validateRelayState(response, relayState, input);
            Assertion assertion = this.decrypter.decrypt((EncryptedElementType)response.getEncryptedAssertions().get(0), Assertion.class);
            if (this.log.isTraceEnabled()) {
                this.log.trace("[{}] Decrypted Assertion: {}", (Object)ResponseProcessorImpl.logId(response, assertion), (Object)ObjectUtils.toStringSafe(assertion));
            }
            this.validateAssertion(assertion, response, input, idpMetadata, validationContext);
            return new ResponseProcessingResultImpl(assertion);
        }
        catch (MessageReplayException e) {
            throw new ResponseProcessingException("Message replay: " + e.getMessage(), e);
        }
        catch (DecryptionException e) {
            throw new ResponseProcessingException("Failed to decrypt assertion: " + e.getMessage(), e);
        }
    }

    public void initialize() throws Exception {
        Assert.notNull((Object)this.decrypter, (String)"Property 'decrypter' must be assigned");
        Assert.notNull((Object)this.messageReplayChecker, (String)"Property 'messageReplayChecker' must be assigned");
        if (this.responseValidationSettings == null) {
            this.responseValidationSettings = new ResponseValidationSettings();
            this.log.info("Using default responseValidationSettings [{}]", (Object)this.responseValidationSettings);
        }
        if (!this.isInitialized) {
            this.metadataCredentialResolver = new MetadataCredentialResolver();
            this.metadataCredentialResolver.setKeyInfoCredentialResolver(DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
            this.metadataCredentialResolver.initialize();
            this.signatureTrustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)this.metadataCredentialResolver, DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
            this.responseValidator = this.createResponseValidator(this.signatureTrustEngine, this.signatureProfileValidator);
            Assert.notNull((Object)this.responseValidator, (String)"createResponseValidator must not return null");
            this.assertionValidator = this.createAssertionValidator(this.signatureTrustEngine, this.signatureProfileValidator);
            Assert.notNull((Object)this.assertionValidator, (String)"createAssertionValidator must not return null");
            this.isInitialized = true;
        }
    }

    protected ResponseValidator createResponseValidator(SignatureTrustEngine signatureTrustEngine, SignaturePrevalidator signatureProfileValidator) {
        return new ResponseValidator(signatureTrustEngine, signatureProfileValidator);
    }

    protected AssertionValidator createAssertionValidator(SignatureTrustEngine signatureTrustEngine, SignaturePrevalidator signatureProfileValidator) {
        return null;
    }

    protected Response decodeResponse(String samlResponse) throws ResponseProcessingException {
        try {
            byte[] decodedBytes = Base64Support.decode((String)samlResponse);
            if (decodedBytes == null) {
                this.log.error("Unable to Base64 decode SAML response message");
                throw new MessageDecodingException("Unable to Base64 decode SAML response message");
            }
            return ObjectUtils.unmarshall(new ByteArrayInputStream(decodedBytes), Response.class);
        }
        catch (XMLParserException | UnmarshallingException | MessageDecodingException e) {
            throw new ResponseProcessingException("Failed to decode message", e);
        }
    }

    protected void validateResponse(Response response, String relayState, ResponseProcessingInput input, EntityDescriptor idpMetadata, ValidationContext validationContext) throws ResponseValidationException {
        IDPSSODescriptor descriptor;
        if (input.getAuthnRequest() == null) {
            String msg = String.format("No AuthnRequest available when processing Response [%s]", ResponseProcessorImpl.logId(response));
            this.log.error("{}", (Object)msg);
            throw new ResponseValidationException(msg);
        }
        IDPSSODescriptor iDPSSODescriptor = descriptor = idpMetadata != null ? idpMetadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") : null;
        if (descriptor == null) {
            throw new ResponseValidationException("Invalid/missing IdP metadata - cannot verify Response signature");
        }
        ResponseValidationParametersBuilder b = (ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)((ResponseValidationParametersBuilder)ResponseValidationParametersBuilder.builder().strictValidation(this.responseValidationSettings.isStrictValidation())).allowedClockSkew(this.responseValidationSettings.getAllowedClockSkew())).maxAgeReceivedMessage(this.responseValidationSettings.getMaxAgeResponse())).signatureRequired(Boolean.TRUE)).signatureValidationCriteriaSet(new CriteriaSet(new Criterion[]{new RoleDescriptorCriterion((RoleDescriptor)descriptor), new UsageCriterion(UsageType.SIGNING)}))).expectedIssuer(idpMetadata.getEntityID())).receiveInstant(input.getReceiveInstant())).receiveUrl(input.getReceiveURL())).authnRequest(input.getAuthnRequest());
        if (validationContext != null) {
            b.addStaticParameters(validationContext.getStaticParameters());
            b.addDynamicParameters(validationContext.getDynamicParameters());
        }
        ValidationContext context = b.build();
        ValidationResult result = this.responseValidator.validate(response, context);
        if (validationContext != null) {
            validationContext.getDynamicParameters().putAll(context.getDynamicParameters());
        }
        switch (result) {
            case VALID: {
                this.log.debug("Response was successfully validated [{}]", (Object)ResponseProcessorImpl.logId(response));
                break;
            }
            case INDETERMINATE: {
                this.log.warn("Validation of Response was indeterminate - {} [{}]", (Object)context.getValidationFailureMessage(), (Object)ResponseProcessorImpl.logId(response));
                break;
            }
            case INVALID: {
                this.log.error("Validation of Response failed - {} [{}]", (Object)context.getValidationFailureMessage(), (Object)ResponseProcessorImpl.logId(response));
                throw new ResponseValidationException(context.getValidationFailureMessage());
            }
        }
    }

    protected void validateRelayState(Response response, String relayState, ResponseProcessingInput input) throws ResponseValidationException {
        boolean relayStateMatch;
        Optional relayStateOptional = relayState == null || relayState.trim().length() == 0 ? Optional.empty() : Optional.of(relayState);
        Optional relayStateInputOptional = input.getRelayState() == null || input.getRelayState().trim().length() == 0 ? Optional.empty() : Optional.of(input.getRelayState());
        boolean bl = relayStateMatch = !relayStateOptional.isPresent() && !relayStateInputOptional.isPresent() || relayStateOptional.isPresent() && relayState.equals(input.getRelayState()) || relayStateInputOptional.isPresent() && input.getRelayState().equals(relayState);
        if (!relayStateMatch) {
            String msg = String.format("RelayState variable received with response (%s) does not match the sent one (%s)", relayState, input.getRelayState());
            this.log.error("{} [{}]", (Object)msg, (Object)ResponseProcessorImpl.logId(response));
            throw new ResponseValidationException(msg);
        }
    }

    protected void validateAssertion(Assertion assertion, Response response, ResponseProcessingInput input, EntityDescriptor idpMetadata, ValidationContext validationContext) throws ResponseValidationException {
        IDPSSODescriptor descriptor;
        IDPSSODescriptor iDPSSODescriptor = descriptor = idpMetadata != null ? idpMetadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") : null;
        if (descriptor == null) {
            throw new ResponseValidationException("Invalid/missing IdP metadata - cannot verify Assertion");
        }
        AuthnRequest authnRequest = input.getAuthnRequest();
        String entityID = null;
        if (authnRequest != null) {
            entityID = authnRequest.getIssuer().getValue();
        }
        AssertionValidationParametersBuilder b = (AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)((AssertionValidationParametersBuilder)AssertionValidationParametersBuilder.builder().strictValidation(this.responseValidationSettings.isStrictValidation())).allowedClockSkew(this.responseValidationSettings.getAllowedClockSkew())).maxAgeReceivedMessage(this.responseValidationSettings.getMaxAgeResponse())).signatureRequired(this.responseValidationSettings.isRequireSignedAssertions())).signatureValidationCriteriaSet(new CriteriaSet(new Criterion[]{new RoleDescriptorCriterion((RoleDescriptor)descriptor), new UsageCriterion(UsageType.SIGNING)}))).receiveInstant(input.getReceiveInstant())).receiveUrl(input.getReceiveURL())).authnRequest(authnRequest)).expectedIssuer(idpMetadata.getEntityID())).responseIssueInstant(response.getIssueInstant().getMillis())).validAudiences(entityID)).validRecipients(input.getReceiveURL(), entityID);
        if (validationContext != null) {
            b.addStaticParameters(validationContext.getStaticParameters());
            b.addDynamicParameters(validationContext.getDynamicParameters());
        }
        ValidationContext context = b.build();
        ValidationResult result = this.assertionValidator.validate(assertion, context);
        if (validationContext != null) {
            validationContext.getDynamicParameters().putAll(context.getDynamicParameters());
        }
        switch (result) {
            case VALID: {
                this.log.debug("Assertion with ID '{}' was successfully validated", (Object)assertion.getID());
                break;
            }
            case INDETERMINATE: {
                this.log.warn("Validation of Assertion with ID '{}' was indeterminate - {}", (Object)assertion.getID(), (Object)context.getValidationFailureMessage());
                break;
            }
            case INVALID: {
                this.log.error("Validation of Assertion failed - {}", (Object)context.getValidationFailureMessage());
                throw new ResponseValidationException(context.getValidationFailureMessage());
            }
        }
    }

    public void setDecrypter(SAMLObjectDecrypter decrypter) {
        this.decrypter = decrypter;
    }

    public void setMessageReplayChecker(MessageReplayChecker messageReplayChecker) {
        this.messageReplayChecker = messageReplayChecker;
    }

    public void setResponseValidationSettings(ResponseValidationSettings responseValidationSettings) {
        this.responseValidationSettings = responseValidationSettings;
    }

    private static String logId(Response response) {
        return String.format("response-id:'%s'", response.getID() != null ? response.getID() : "<empty>");
    }

    private static String logId(Response response, Assertion assertion) {
        return String.format("response-id:'%s',assertion-id:'%s'", response.getID() != null ? response.getID() : "<empty>", assertion.getID() != null ? assertion.getID() : "<empty>");
    }
}

