/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.NameID;
import se.litsec.opensaml.saml2.common.response.ResponseProcessingResult;

public class ResponseProcessingResultImpl
implements ResponseProcessingResult {
    private Assertion assertion;

    public ResponseProcessingResultImpl(Assertion assertion) {
        this.assertion = assertion;
    }

    @Override
    public Assertion getAssertion() {
        return this.assertion;
    }

    @Override
    public List<Attribute> getAttributes() {
        try {
            return Collections.unmodifiableList(((AttributeStatement)this.assertion.getAttributeStatements().get(0)).getAttributes());
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public String getAuthnContextClassUri() {
        try {
            return ((AuthnStatement)this.assertion.getAuthnStatements().get(0)).getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public DateTime getAuthnInstant() {
        DateTime authnInstant = ((AuthnStatement)this.assertion.getAuthnStatements().get(0)).getAuthnInstant();
        if (authnInstant.isAfterNow()) {
            return new DateTime();
        }
        return authnInstant;
    }

    @Override
    public String getIssuer() {
        try {
            return this.assertion.getIssuer().getValue();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public NameID getSubjectNameID() {
        try {
            return this.assertion.getSubject().getNameID();
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

