/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import net.shibboleth.utilities.java.support.annotation.Duration;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.storage.ReplayCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import se.litsec.opensaml.saml2.common.response.MessageReplayChecker;
import se.litsec.opensaml.saml2.common.response.MessageReplayException;

public class MessageReplayCheckerImpl
implements MessageReplayChecker,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(MessageReplayCheckerImpl.class);
    private ReplayCache replayCache;
    @Duration
    private long replayCacheExpiration = 300000L;
    private String replayCacheName;

    @Override
    public void checkReplay(String id) throws MessageReplayException {
        if (!this.replayCache.check(this.replayCacheName, id, this.replayCacheExpiration + System.currentTimeMillis())) {
            String msg = String.format("Replay check of ID '%s' failed", id);
            this.log.warn(msg);
            throw new MessageReplayException(msg);
        }
        this.log.debug("Message replay check of ID '{}' succeeded", (Object)id);
    }

    @Override
    public void checkReplay(SAMLObject object) throws MessageReplayException, IllegalArgumentException {
        String id = null;
        if (object instanceof Response) {
            id = ((Response)object).getID();
        } else if (object instanceof Assertion) {
            id = ((Assertion)object).getID();
        }
        if (id == null) {
            throw new IllegalArgumentException("Unsupported object type");
        }
        this.checkReplay(id);
    }

    public void setReplayCache(ReplayCache replayCache) {
        this.replayCache = replayCache;
    }

    public void setReplayCacheName(String replayCacheName) {
        this.replayCacheName = replayCacheName;
    }

    @Duration
    public void setReplayCacheExpiration(long replayCacheExpiration) {
        if (replayCacheExpiration < 0L) {
            throw new IllegalArgumentException("replayCacheExpiration must be greater than 0");
        }
        this.replayCacheExpiration = replayCacheExpiration;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.replayCache, (String)"Property 'replayCache' must be assigned");
        Assert.hasText((String)this.replayCacheName, (String)"Property 'replayCacheName' must be assigned");
    }
}

